/**
 * @(#)ResponseCodeEnum.java, 2022/11/14.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.meta;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author zcwang
 * @Date 2022/11/14
 */
public enum ResponseCodeEnum {
    ZERO_CODE_SUCCESS(0, "成功"),
    SUCCESS(200, "成功"),
    BAD_REQUEST(400, "错误请求"),
    SC_UNAUTHORIZED(401, "用户未登录"),
    FORBIDDEN(403, "操作无权限"),
    NO_FOUND(404, "服务器上没有请求的资源"),
    TOO_MANY_REQUESTS(429, "服务请求达到上限（限流）"),
    INTERNAL_ERROR(500, "系统内部错误"),
    SERVICE_DEGRADATION(50010, "服务已降级"),
    PARAM_ERROR(51000, "参数错误"),
    NO_ROLE_AUTH(51006, "用户无角色权限"),
    UNAUTHORIZED(51007, "用户未登录"),
    RISK_CONTROL_USERS(51010, "风控用户"),
    NO_CROWD_AUTH(51011, "用户人群不满足"),
    ACT_DISSATISFIED(52000, "活动不满足条件"),
    BIZ_EXCEPTION(52001, "业务异常"),
    SYSTEM_EXCEPTION(52002, "系统异常"),
    UNKNOWN_ERROR(52003, "未知错误"),
    RPC_ERROR(52004, "rpc错误"),
    RPC_RESULT_ERROR(52003, "rpc结果错误"),
    FRAMEWORK_EXCEPTION(55000, "martech-act-framework异常");

    private final Integer code;
    private final String msg;
    static Map<Integer, ResponseCodeEnum> map = new HashMap();

    private ResponseCodeEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static ResponseCodeEnum valueOf(Integer value) {
        return (ResponseCodeEnum)map.get(value);
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    static {
        ResponseCodeEnum[] var0 = values();
        int var1 = var0.length;

        for(int var2 = 0; var2 < var1; ++var2) {
            ResponseCodeEnum codeEnum = var0[var2];
            map.put(codeEnum.getCode(), codeEnum);
        }

    }
}