/**
 * @(#)ChangeFlowReq.java, 2022/11/14.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.meta.model.req;

import java.util.List;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;


import lombok.Data;

/**
 * @Author zcwang
 * @Date 2022/11/14
 */
@Data
public class ChangeFlowSubmitReq {

    /**
     * 工单id
     */
    @NotNull(message = "工单id不能为空")
    private Long flowId;

    /**
     * 当前节点id
     */
    @NotBlank(message = "当前节点不能为空")
    private String currentNodeId;

    /**
     * 一级类型id
     */
    private int parentChangeClassId;
    /**
     * 二级类型id
     */
    private int sonChangeClassId;
    /**
     * 变更商品
     */
    private String changeItems;
    /**
     * 变更供应商
     */
    private String changeSupplier;
    /**
     * 变更原因
     */
    private String changeReason;
    /**
     * 变更内容
     */
    private String changeContent;

    /**
     * 变更工单附件
     */
    private List<ChangeFlowFile> files;

    /**
     * 变更潜在风险
     */
    private String changeRiskDesc;
    /**
     * 变更验证措施
     */
    private String changeChecking;
    /**
     * 变更收益类型
     */
    private Integer changeProfit;
    /**
     * 变更收益说明
     */
    private String changeProfitDesc;
    /**
     * 变更结果确认时间，时间戳
     */
    private long changeConfirmResultTime;
    /**
     * 变更行动项
     */
    private List<ChangeExecProject> changeExecProjectList;
    /**
     * 变更结论
     */
    private Long changeResult;
    /**
     * 原因说明（取消时存在）
     */
    private String changeResultDesc;
    /**
     * 备注
     */
    private String remark;
}