/**
 * @(#)TestController.java, 2022/11/28.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.web.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.biz.service.rpc.TodoService;
import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.dal.entity.ChangeRecord;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierSendService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierSearchRemoteReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.SupplierSimpleRsp;
import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author zcwang
 * @Date 2022/11/28
 */
@Slf4j
@RestController
@RequestMapping("/test")
public class TestController {

    @Autowired
    private TodoService todoService;

    @PostMapping("/createToDo")
    public AjaxResult<Void> createTodoTask(ChangeRecord entity) {
        log.info("[createToDoTask] entity:{}", JSON.toJSONString(entity));
        todoService.createTodoTask(entity);
        return AjaxResult.success();
    }

    @PostMapping("/progressTodo")
    public AjaxResult<Void> progressTodoTask(ChangeRecord entity, Integer operateType) {
        log.info("[createToDoTask] entity:{}, operateType:{}", JSON.toJSONString(entity), operateType);
        todoService.progressTodoTask(entity, operateType);
        return AjaxResult.success();
    }

    @Autowired
    private FlowRpcSupplierSendService service;

    @PostMapping("/test")
    public AjaxResponse<List<SupplierSimpleRsp>> test1(@RequestParam String name){
        SupplierSearchRemoteReq req = new SupplierSearchRemoteReq();
        req.setSearchText(name);
        return service.queryByConditionForQc(req);
    }
}