package com.netease.mail.yanxuan.change.biz.service.change;

import com.netease.mail.yanxuan.change.dal.entity.ChangeType;

import java.util.List;

/**
 * @author WangJiaXiang
 * @date 2022/11/11/011$
 * 基础服务用来方便内部调用
 */
public interface ChangeTypeService {

    /**
     * 查询变更类型表
     * @param id id
     * @param deleteTab  是否查伪删除数据
     * @return
     */
    List<ChangeType> queryChangeType(Long id,Boolean deleteTab);

    /**
     * 添加类型 如果遇到内容一样的情况下不能覆盖直接修改伪删状态  涉及到二级关联信息
     * 关系是一对一绑定的所以List里面只会存储两条对象
     * @param changeTypes
     * @return
     */
    List<ChangeType> addChangeType(List<ChangeType> changeTypes);

    Boolean updateChangeType(List<ChangeType> changeTypes);

    /**
     * 判断类型是否存在
     * @param typeName
     * @return
     */
    Boolean queryChangeType(String typeName);

}
