package com.netease.mail.yanxuan.change.biz.service.impl;

import com.netease.mail.yanxuan.change.biz.service.InteriorChangeConfigService;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeConfigService;
import com.netease.mail.yanxuan.change.common.enums.ChangeCommanderEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeSubjectEnum;
import com.netease.mail.yanxuan.change.dal.entity.ChangeConfig;
import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeCommanderPO;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author WangJiaXiang
 * @date 2022/11/18/018$
 */
public class InteriorChangeConfigServiceImpl implements InteriorChangeConfigService {

    @Autowired
    private ChangeConfigService changeConfigService;

    @Override
    public String queryCommanderInfo(ChangeCommanderPO changeCommander) {
        //获取模板名称
        ChangeConfig changeConfig = changeConfigService.queryChangeConfig(changeCommander.getId());
        //查询出当前模板配置中选择的 角色
        ChangeCommanderEnum changeCommanderEnum = ChangeCommanderEnum.getChangeCommanderEnum(changeConfig.getChangeCommanderType());
        //直接排除 选项为固定人 或者发起人
        if (changeCommanderEnum.getId() == 1 || changeCommanderEnum.getId() == 2){
            return changeConfig.getChangeCommander();
        }
        ChangeSubjectEnum changeSubjectEnum = ChangeSubjectEnum.getChangeSubjectEnum(changeConfig.getChangeSubject());
        if (changeSubjectEnum.getType() == 1){
            //商品变更
            return queryGoodsCommander(changeCommanderEnum,changeCommander.getGoodsInfos(),changeConfig.getChangeCommander());
        }else if (changeSubjectEnum.getType() == 2){
            //供应商  采购 计划 SQE
            return queryChangeSupplier(changeCommanderEnum,changeCommander.getChangeSupplier(),changeConfig.getChangeCommander());
        }
        //其他变更 备注 其他变更之后固定人 和发起人在上面判断会被排除掉
        return changeConfig.getChangeCommander();

    }

    /**
     * 商品的最终角色查询
     * @param commanderEnum   查询方向 枚举
     * @param goodsInfos  商品的列表
     * @param commander   商品的关联角色
     * @return
     */
    private String queryGoodsCommander(ChangeCommanderEnum commanderEnum,List<String> goodsInfos,String commander){
        if (commanderEnum.getId() != 3 || goodsInfos == null || goodsInfos.size() == 0 || commander == null){
            return "类型错误 或者未选择商品";
        }
        Map<String,Integer> map = new HashMap<String,Integer>();
        //记录最大出现次数
        int temp = 0;
        //记录最大值
        String name = "";
        //记录出现的所有值
        List<String> commanders = new ArrayList<String>();
        if (commander.equals("商品BU")){

        }else if (commander.equals("采购")){

        }else if (commander.equals("计划")){

        }else if (commander.equals("SQE")){

        }
        for (String goods : commanders){
            if (!map.containsKey(goods)){
                map.put(goods,1);
            }else{
                Integer integer = map.get(goods);
                ++integer;
                if (temp < integer){
                    temp = integer;
                    name = goods;
                }
                map.put(goods,integer);
            }
        }
        return name;
    }

    /**
     * 供应商角色最终查询
     * @param commanderEnum   查询方向 枚举
     * @param changeSupplier 供应商信息
     * @param commander      供应商关联角色
     * @return
     */
    private String queryChangeSupplier(ChangeCommanderEnum commanderEnum,String changeSupplier,String commander){
        if (commanderEnum.getId() != 4 || changeSupplier == null || commander == null){
            return "返回空值 或者指示值";
        }
        //changeSupplier 根据提供的信息去查询 最终返回
        if (commander.equals("采购")){

        }else if (commander.equals("计划")){

        }else if (commander.equals("SQE")){

        }
        return null;
    }


}
