/**
 * @(#)ChangeSubjectEnum.java, 2022/11/14.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.common.enums;

/**
 * @Author zcwang
 * @Date 2022/11/14
 * 变更主体枚举
 */
public enum ChangeSubjectEnum {

    PRODUCT(1, "商品变更"),
    SUPPLIER(2, "供应商变更"),
    OTHER(3, "其他变更");

    private Integer type;

    private String desc;

    ChangeSubjectEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static Boolean getByType(Integer type) {
        for (ChangeSubjectEnum value : ChangeSubjectEnum.values()) {
            if (value.getType().equals(type)) {
                return true;
            }
        }
        return false;
    }

    public static ChangeSubjectEnum getChangeSubjectEnum(Integer id){
        for (ChangeSubjectEnum day : ChangeSubjectEnum.values()) {
            if (id == day.getType()){
                return day;
            }
        }
        return null;
    }


}