package com.netease.mail.yanxuan.change.integration.flow.supplier.impl;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierInfoService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierRelatedUserReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.SupplierUserRsp;
import com.netease.mail.yanxuan.change.integration.rpc.RpcListData;
import com.netease.mail.yanxuan.change.integration.rpc.RpcTemplate;

/**
 * @author WangJiaXiang
 * @date 2022/12/8/008$
 */
@Service
public class FlowRpcSupplierInfoServiceImpl implements FlowRpcSupplierInfoService {

    private final String path = "/api/supplier/batchGetSupplierRelatedUser.json";

    @Autowired
    private RpcTemplate rpcTemplate;

    @Value("${supplier.url}")
    private String riskUrl;

    Logger logger = LoggerFactory.getLogger(FlowRpcSupplierInfoServiceImpl.class);

    @Override
    public List<SupplierUserRsp> querySupplierRelatedUser(SupplierRelatedUserReq req) {
        String url = "http://127.0.0.1:8550/proxy/test-v1.yanxuan-supplier-ms.service.mailsaas/api/supplier/batchGetSupplierRelatedUser.json";
        List<SupplierUserRsp> objects = rpcTemplate.postJson(url, JSON.toJSONString(req),500,new RpcListData<>(SupplierUserRsp.class));
        logger.error("请求返回结果"+objects);
        return objects;
    }
}
