package com.netease.mail.yanxuan.change.biz.meta;


import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author lwtang
 */
@EqualsAndHashCode()
@Data
@Accessors(chain = true)
public class AjaxResult<T> {

    private static final long serialVersionUID = 1L;

    private Integer code;

    private String msg;

    private T data;

    private Exception e;

    public Boolean isSuccess() {
        return this.code.equals(ResponseCodeEnum.SUCCESS.getCode());
    }

    public Boolean isFail() {
        return !isSuccess();
    }

    public static <R> AjaxResult<R> success() {
        return AjaxResult.of(ResponseCodeEnum.SUCCESS);
    }

    public static <R> AjaxResult<R> success(R data) {
        return AjaxResult.<R>of(ResponseCodeEnum.SUCCESS).setData(data);
    }

    public static <R> AjaxResult<R> error() {
        return AjaxResult.of(ResponseCodeEnum.INTERNAL_ERROR);
    }
    public static <R> AjaxResult<R> error(Exception e) {
        return AjaxResult.<R>of(ResponseCodeEnum.INTERNAL_ERROR).setE(e);
    }

    public static <R> AjaxResult<R> badRequest() {
        return AjaxResult.of(ResponseCodeEnum.BAD_REQUEST);
    }

    public static <R> AjaxResult<R> badRequest(String msg) {
        return AjaxResult.<R>of(ResponseCodeEnum.BAD_REQUEST).setMsg(msg);
    }

    public static <R> AjaxResult<R> badRequest(Exception e) {
        return AjaxResult.<R>of(ResponseCodeEnum.BAD_REQUEST).setE(e);
    }

    public static <R> AjaxResult<R> badRequest(String msg, Exception e) {
        return AjaxResult.<R>of(ResponseCodeEnum.BAD_REQUEST).setMsg(msg).setE(e);
    }

    public static <R> AjaxResult<R> of(ResponseCodeEnum code) {
        return new AjaxResult<R>().setCode(code.getCode()).setMsg(code.getMsg());
    }

    public static <R> AjaxResult<R> of(Integer code, String msg) {
        return new AjaxResult<R>().setCode(code).setMsg(msg);
    }

    public static <R> AjaxResult<R> of(Integer code, String msg, R data) {
        return AjaxResult.<R>of(code, msg).setData(data);
    }

    public static <R> AjaxResult<R> of(Integer code, String msg, R data, Exception e) {
        return AjaxResult.of(code, msg, data).setE(e);
    }
}
