/**
 * @(#)ChangeConfig.java, 2022/11/11.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.entity;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author zcwang
 * @Date 2022/11/11
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
@Entity
@Table(name = "TB_YX_QC_CHANGE_CONFIG")
public class ChangeConfig {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 变更主体
     */
    private Integer changeSubject;

    /**
     * 一级变更类型id
     */
    private Long parentChangeClassId;

    /**
     * 二级变更类型id
     */
    private Long sonChangeClassId;

    /**
     * 变更等级
     */
    private Integer changeLevel;

    /**
     * 变更负责部门名
     */
    private String changeDepartment;

    /**
     * 变更执行部门
     */
    private String participateChangeExecDepartment;

    /**
     * 变更负责人类型
     */
    private Integer changeCommanderType;

    /**
     * 变更负责人详情（不同类型存储不同内容）
     */
    private String changeCommander;

    /**
     * 是否需要资料上传
     */
    private Integer needFile;

    /**
     * 创建时间
     */
    private Long createTime;

    /**
     * 更新时间
     */
    private Long updateTime;
}