/**
 * @(#)BasicChangeFlowVO.java, 2022/11/21.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.meta.model.vo;

import java.util.List;

import com.netease.mail.yanxuan.change.dal.entity.ChangeFile;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowFile;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author zcwang
 * @Date 2022/11/21
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class BasicChangeFlowVO {

    /**
     * 一级变更类型id
     */
    private Long parentChangeClassId;

    /**
     * 二级变更类型id
     */
    private Long sonChangeClassId;

    /**
     * 变更主体
     */
    private Integer changeSubject;

    /**
     * 变更商品（变更主体为商品时有效）
     */
    private String changeItem;

    /**
     * 变更供应商（变更主体为供应商时有效）
     */
    private String changeSupplier;

    /**
     * 变更原因
     */
    private String changeReason;

    /**
     * 变更内容
     */
    private String changeContent;

    /**
     * 变更潜在风险描述
     */
    private String changeRiskDesc;

    /**
     * 变更收益类型
     */
    private Integer changeProfit;

    /**
     * 变更收益说明
     */
    private String changeProfitDesc;

    /**
     * 附件
     */
    private List<ChangeFlowFile> files;

}