/**
 * @(#)ChangeFlowExecVO.java, 2022/11/21.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.meta.model.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author zcwang
 * @Date 2022/11/21
 */
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Data
public class ChangeFlowExecVO {
    /**
     * 变更记录id
     */
    private Long changeRecordId;

    /**
     * 变更执行部门名
     */
    private String changeExecDepartment;

    /**
     * 变更行动人（不同类型存储不同内容）
     */
    private String changeExecUser;

    /**
     * 变更风险描述
     */
    private String changeRiskDesc;

    /**
     * 行动项
     */
    private String changeExecProject;

    /**
     * 变更措施验证
     */
    private String changeChecking;

    /**
     * 行动完成时间
     */
    private Long changeExecFinishTime;

    /**
     * 行动完成情况
     */
    private String changeExecFinishDesc;
}