package com.netease.mail.yanxuan.change.integration.email.email;

/**
 * 常量定义
 *
 * @author lwtang
 * @date 2018-10-16
 */
public class Constants {

    public static final String EHC_PRODUCT_CODE = "ehc";

    public static final Integer ONE_HUNDRED = 100;

    public static final Integer ONE_THOUSAND = 1000;

    public static final String SQE_NAME = "sqe_name:%s";

    public static final Integer MAX_QUERY_SIZE = 200;

    public static final String REQUEST_HEADER_PRODUCT_CODE = "product-code";

    /**
     * GlobalId 自增redis值
     */
    public static final String ABNORMAL_FLOW_GLOBAL_ID = "abnormalFlowGlobalId";

    public static final String TASK_FLOW_GLOBAL_ID = "taskFlowGlobalId";

    /**
     * GlobalId前缀
     */
    public static final String ABNORMAL_FLOW_GLOBAL_NAME = "QC-ABNORMAL-FLOW-";

    /**
     * 所有异常工单缓存key
     */
    public static final String ALL_ABNORMAL_FLOW_KEY = "all_abnormal_flow";

    /**
     * 新增工单key
     */
    public static final String ADD_NEW_FLOW_KEY = "add_new_flow_%s";

    /**
     *
     */
    public static final String TITLE_1 = "您好，系统内临期、延期的异常、任务处理工单汇总如下，请及时处理！";

    /**
     *
     */
    public static final String TITLE_2 = "您好，您的小组成员临期或过期的异常问题处理工单如下，请及时处理！";

    /**
     *
     */
    public static final String TITLE_3 = "您好，系统内临期、延期的异常、任务处理工单汇总如下，无需您处理，请知悉！";

    /**
     * 舆情配置附加信息 前N个周期的数据均超过阈值
     */
    public static final String ABNORMAL_RULE_EXCEEDING_CYCLE_NUM = "前%s个周期的数据均超过阈值";

    /**
     * 舆情配置附加信息 前N个周期的数据对比呈现持续上升趋势
     */
    public static final String ABNORMAL_RULE_RISING_CYCLE_NUM = "前%s个周期的数据对比呈现持续上升趋势";

    /**
     * 舆情配置附加信息 且
     */
    public static final String ABNORMAL_RULE_AND = "且";

    /**
     * 舆情配置附加信息 或
     */
    public static final String ABNORMAL_RULE_OR = "或";

    /**
     * 通用配置入口id 谛听标签入库
     */
    public static final String COMMON_MAX_ID = "maxId";

    /**
     * 通用配置入口id 普通标签入库
     */
    public static final String COMMON_ID = "maxId";

    /**
     * 正常工单缓存key
     */
    public static final String FLOW_CACHE_KEY = "flow_cache_key";

    /**
     * 过期工单缓存key
     */
    public static final String OVERDUE_FLOW_CACHE_KEY = "overdue_flow_cache_key";

    /**
     * helios cacheName
     */
    public static final String EHC_CACHE_LIST = "EHC_CACHE_LIST";

    public static final String EHC_CACHE_STRING = "EHC_CACHE_STRING";

    /**
     * 正常工单缓存key
     */
    public static final String EHC_FLOW_CACHE_KEY = "ehc_flow_cache_key";

    /**
     * 过期工单缓存key
     */
    public static final String EHC_OVERDUE_FLOW_CACHE_KEY = "ehc_overdue_flow_cache_key";

    public static final String FLOW_ASSIGNED_PROCESSOR_UID = "flow_assigned_processor_uid_";

    public static final String FLOW_APPROVE_USER = "flow_approve_user_";

    public static final String AUTO_SUBMIT_FLOW = "auto_submit_flow_";

    public static final String APPROVER_USER = "approver_user_";

    /**
     * 舆情异常创建 退货
     */
    public static final String RETURN = "退货";

    /**
     * 舆情异常创建 差评
     */
    public static final String BAD_REVIEW = "差评";

    /**
     * redis 商品前缀 itemId 退/换货 时间类型 二级问题
     */
    public static final String RECEIVE_GOODS = "goods_%s_%s_%s_%s";

    /**
     * redis 供应商前缀 supplierId 退/换货 时间类型 二级问题
     */
    public static final String RECEIVE_SUPPLIER = "goods_%s_%s_%s_%s";

    /**
     * 异常创建信息 商品
     */
    public static final String ABNORMAL_CREATE_FIRST_GOOD = "%s-%s在质量%s排行榜发现商品：%s+%s存在质量问题。";

    public static final String ABNORMAL_CREATE_SECOND_GOOD = "该商品总计%s次数%s pcs，销量%s pcs，质量%s率为%s%%。";

    public static final String ABNORMAL_CREATE_THIRD_GOOD = "其中当前质量问题：%s,有质量%s%s pcs，该问题质量%s率为%s%%。";

    public static final String ABNORMAL_CREATE_FOURTH_GOOD = "该商品历史累计%s率为%s%%。";

    /**
     * 异常创建信息 userName
     */
    public static final String ABNORMAL_CREATE_USER_NAME = "品控工作台";

    public static final String ABNORMAL_CREATE_USER_EMAIL = "yanxuan@service.netease.com";

    public static final String ABNORMAL_CREATE_PRODUCT_CODE = "ecr";

    public static final String ABNORMAL_CREATE_PROBLEM_GOODS = "%s%s,质量问题：%s";

    public static final String ABNORMAL_CREATE_PROBLEM_SUPPLIER = "%s%s,质量问题：%s";

    /**
     * 异常创建信息 供应商
     */
    public static final String ABNORMAL_CREATE_FIRST_SUPPLIER = "%s-%s在质量%s排行榜发现商品：%s+%s存在质量问题。";

    public static final String ABNORMAL_CREATE_SECOND_SUPPLIER = "该供应商总计%s次数%s pcs，销量%s pcs，质量%s率为%s%%。";

    public static final String ABNORMAL_CREATE_THIRD_SUPPLIER = "其中当前质量问题：%s,有质量%s%s pcs，该问题质量%s率为%s%%。";

    public static final String ABNORMAL_CREATE_FOURTH_SUPPLIER = "该供应商历史累计%s率为%s%%。";

    /**
     * 异常创建信息 数据更新异常
     */
    public static final String ABNORMAL_CREATE_DATA_UPDATE_NOT = "数仓数据%s未更新。";

    public static final String ABNORMAL_CREATE_DATA = "品控ECR舆情监控异常创建,";

    /**
     * 周
     */
    public static final String ABNORMAL_CREATE_WEEKS = "周";

    /**
     * 月
     */
    public static final String ABNORMAL_CREATE_MONTH = "月";

    /**
     * 节点错误
     */
    public static final String FLOWX_NODE_ERROR = "%s节点无法保存或提交";

    public static final String SUBMIT_OPERATION = "提交工单";

    public static final String AUTO_SUBMIT_OPERATION = "系统自动提交工单";

    public static final String SYSTEM_AUTO_SUBMIT_OPERATION = "系统自动提交工单";

    public static final String SYSTEM_USERNAME = "系统自动提交";

    /**
     * 批量事件任务工单TopoID
     */
    public static final String BATHTOPOID = "ehc_batch_event_task_flow";

    /**
     * 批量任务人员类型
     */
    public static final String  EXECUTORTYPE= "严选人员";

    /**
     * hash map 初始化大小
     */
    public static final Integer INIT_HASH_MAP_SIZE = 10;

    public static final String SUPPLIER_PREFIX = "YX";
    /**
     * 解决措施工单过期缓存key
     */
    public static final String EHC_TASK_FLOW_OVERDUE_CACHE_KEY = "ehc_task_flow_overdue_cache_key";
    /**
     * 解决措施工单正常缓存key
     */
    public static final String EHC_TASK_FLOW_CACHE_KEY = "ehc_task_flow_cache_key";
    /**
     * 供应商惩罚工单过期key
     */
    public static final String EHC_PUNISH_FLOW_OVERDUE_CACHE_KEY = "ehc_punish_flow_overdue_cache_key";
    /**
     * 供应商惩罚工单正常key
     */
    public static final String EHC_PUNISH_FLOW_CACHE_KEY = "ehc_punish_flow_cache_key";
    /**
     * 批量事件工单过期key
     */
    public static final String EHC_EVENT_FLOW_OVERDUE_CACHE_KEY = "ehc_event_flow_overdue_cache_key";
    /**
     * 批量事件工单正常key
     */
    public static final String EHC_EVENT_FLOW_CACHE_KEY = "ehc_event_flow_cache_key";

    /**
     * 对比参数默认值
     */
    public static final Integer ALL_VALUE = -1;

    // 工单业务数据操作key
    public static final String FLOW_OPERATION_KEY = "operation";

    public static final String YANXUAN_NOS_PREFIX_URL = "yanxuan.nosdn.127.net";

    /**
     * 默认一页数据量
     */
    public static final Integer DEFAULT_PAGE_SIZE = 10;

    /**
     * 默认页码
     */
    public static final Integer DEFAULT_PAGE_NUM = 1;

    /**
     * 异常问题名称最大长度
     */
    public static final int ABNORMAL_NAME_MAX_LENGTH = 500;

    /**
     * 异常问题描述最大长度
     */
    public static final int ABNORMAL_DISCOVER_DESC_MAX_LENGTH = 800;

    /**
     * 审核依据最大长度
     */
    public static final int ABNORMAL_AUDIT_BASIS_MAX_LENGTH = 50;

    /**
     * 审核内容最大长度
     */
    public static final int ABNORMAL_AUDIT_CONTENT_MAX_LENGTH = 500;

    /**
     * 标签最大长度
     */
    public static final int LABEL_MAX_LENGTH = 2000;

    public static final String ABNORMAL_PROBLEM_NAME_WAREHOUSE = "%s仓库涉及%s单延迟未发货";

    public static final String ABNORMAL_PROBLEM_DESCRIPTION_WAREHOUSE = "%s仓库涉及%s单延迟未发货";

    public static final String ABNORMAL_PROBLEM_NAME_CARRIER = "%sB端运输%s件异常商品";

    public static final String ABNORMAL_PROBLEM_DESCRIPTION_CARRIER = "%s从%s到%s的B端干线运输环节，产生%s件异常商品，仓库以物流原因操作转次";

    public static final String ABNORMAL_CREATE_NAME = "异常中心";

    public static final String ABNORMAL_CREATE_EMAIL = "yanxuan@corp.netease.com";
}
