package com.netease.mail.yanxuan.change.integration.email.email;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class OverTimeUserVo {

    /**
     * 接收人邮箱
     */
    private String uid;

    /**
     * 接收人名字
     */
    private String uname;

    /**
     * 工单id
     */
    private String flowId;

    /**
     * 异常问题名称
     */
    private String abnormalName;

    /**
     * 1:主工单，2：临时措施，3：供应商惩罚，4：批量事件
     *
     * @see com.netease.mail.yanxuan.ehc.core.meta.enums.FlowCheckTypeEnum
     */
    private Integer type;

    /**
     * 当前节点
     */
    private String currentNode;

    /**
     * 当前节点名称
     */
    private String currentNodeName;

    /**
     * 异常负责人
     */
    private String abnormalPrincipalUserName;

    /**
     * 执行人
     */
    private String processUserName;

    /**
     * 异常问题类型
     */
    private Long problemTypeId;

    /**
     * 异常问题类型名称
     */
    private String problemTypeName;

    /**
     * 对应的监控规则（异常问题工单）
     *
     * @see com.netease.mail.yanxuan.ehc.core.meta.enums.MonitoringRulesEnum
     */
    private String monitoringRule;

    /**
     * 剩余/延期天数（如果延期展示负数）
     */
    private Long surplusDays;

    /**
     * 时间状态
     *
     * @see com.netease.mail.yanxuan.ehc.core.meta.enums.EmailTimeStatusEnum
     */
    private Integer timeStatus;

    /**
     * 时间状态
     */
    private String timeStatusName;

    /**
     * 创建时间
     */
    private String createTime;

    /**
     * 截止时间
     */
    private String deadLineTime;

    /**
     * 工单跳转链接
     */
    private String flowUrl;
    /**
     * 部门名称
     */
    private String execUserOrgPosName;

}
