package com.netease.mail.yanxuan.change.integration.email.enums;

import lombok.AllArgsConstructor;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
@AllArgsConstructor
public enum ExecUserTypeEnum {

    YANXUAN_MEMBER(1,"严选人员"),

    SUPPLIER(2,"供应商"),

    LOGISTICS_SERVICE_PROVIDER(3,"物流服务商"),

    WAREHOUSE_SERVICE_PROVIDER(4,"仓库服务商"),

    RETURN_WAREHOUSE_SERVICE_PROVIDER(5,"退货仓服务商");


    private int value;

    private String name;

    public static String getName(Integer type) {
        List<ExecUserTypeEnum> collect = Arrays.stream(ExecUserTypeEnum.values())
                .filter(e -> e.getValue().equals(type)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            return collect.get(0).getName();
        }
        return "";
    }

    public String getName() {
        return name;
    }

    public Integer getValue() {
        return value;
    }
}
