/**
 * @(#)SupplierSendService.java, 2022/12/8.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.service.rpc;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.dal.entity.ChangeRecord;
import com.netease.mail.yanxuan.change.integration.email.email.EmailFactor;
import com.netease.mail.yanxuan.change.integration.email.enums.EmailTemplateEnum;
import com.netease.mail.yanxuan.change.integration.email.enums.EmailTypeEnum;
import com.netease.mail.yanxuan.change.integration.email.service.impl.EmailTemplateServiceImpl;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierSendService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierSendEmailReq;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author zcwang
 * @Date 2022/12/8
 */
@Slf4j
@Component
public class SupplierSendService {

    @Autowired
    private FlowRpcSupplierSendService flowRpcSupplierSendService;

    @Autowired
    private EmailTemplateServiceImpl emailTemplateService;


    public void sendSupplierEmail(String supplier, String subjectParam, EmailTemplateEnum emailTemplateEnum,
        Map<String, Object> param) {
        try {
            SupplierSendEmailReq req = new SupplierSendEmailReq();
            req.setSupplierId(supplier);
            req.setMailSubject(subjectParam);
            EmailFactor factor = EmailFactor.builder().data(param).emailTemplateEnum(emailTemplateEnum)
                .subject(req.getMailSubject()).type(EmailTypeEnum.HTML.getType()).build();
            req.setMailContent(this.content(factor));
            log.debug("[sendSupplierEmail] 发送供应商邮件内容 subjectParam:{}, req:{}", subjectParam, JSON.toJSONString(req));
            flowRpcSupplierSendService.sendEmail(req);
        } catch (Exception e) {
            log.error("[op:sendSupplierEmail] error,supplier:{},subjectParam:{}, e:{}", supplier, subjectParam, e);
        }
    }

    /**
     * 根据邮件模版获取邮件内容
     *
     * @param emailFactor
     * @return
     */

    private String content(EmailFactor emailFactor) {
        EmailTemplateEnum emailTemplateEnum = emailFactor.getEmailTemplateEnum();
        return emailTemplateService.template(emailTemplateEnum.getCode(), emailFactor.getData(),
                emailFactor.getType());
    }
}