/**
 * @(#)ChangeFileServiceImpl.java, 2022/11/21.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.netease.mail.yanxuan.change.biz.service.ChangeFileService;
import com.netease.mail.yanxuan.change.dal.entity.ChangeFile;
import com.netease.mail.yanxuan.change.dal.mapper.ChangeFileMapper;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowFile;

/**
 * @Author zcwang
 * @Date 2022/11/21
 */
@Service
public class ChangeFileServiceImpl implements ChangeFileService {

    @Autowired
    private ChangeFileMapper changeFileMapper;

    @Override
    public List<ChangeFlowFile> getChangeFileList(Long changeRecordId) {
        List<ChangeFile> changeFiles = changeFileMapper.selectByChangeRecordId(changeRecordId);
        if (CollectionUtils.isNotEmpty(changeFiles)) {
            return changeFiles.stream().map(c -> ChangeFlowFile.builder().fileType(c.getFileType()).fileName(c.getFileName())
                .fileUrl(c.getFileUrl()).build()).collect(Collectors.toList());
        }
        return new ArrayList<>();
    }

    @Override
    public void batchSaveRecord(List<ChangeFile> changeFiles) {
        changeFileMapper.insertList(changeFiles);
    }

    @Override
    public Integer deleteByChangeRecordId(Long changeRecordId) {
        return changeFileMapper.deleteByBaseId(changeRecordId);
    }

    @Override
    public void saveRecord(ChangeFile changeFile) {
        changeFileMapper.insertSelective(changeFile);
    }
}