/**
 * @(#)ChangeFlowExcelVo.java, 2022/12/8.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.integration.excel;

import java.util.ArrayList;
import java.util.List;

import com.netease.mail.dp.des.common.api.enums.ExcelCellType;
import com.netease.mail.dp.des.process.api.entity.ExcelCell;
import com.netease.mail.yanxuan.change.common.anno.ExcelTitleName;
import com.netease.mail.yanxuan.change.common.enums.ChangeStatusEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeSubjectEnum;

import lombok.Data;

/**
 * @Author zcwang
 * @Date 2022/12/8
 */
@Data
public class ChangeFlowExcelVo {
    /**
     * 主键id
     */
    @ExcelTitleName(title = "主键id", order = 1)
    private Long id;

    /**
     * 变更主体
     * @see ChangeSubjectEnum
     */
    @ExcelTitleName(title = "变更主体", order = 2)
    private String changeSubject;
    /**
     * 变更类型，一级类型>二级类型
     */
    @ExcelTitleName(title = "变更类型", order = 3)
    private String changeType;

    /**
     * 变更负责部门名
     */
    @ExcelTitleName(title = "变更负责部门名", order = 4)
    private String changeDepartment;

    /**
     * 变更内容
     */
    @ExcelTitleName(title = "变更内容", order = 5)
    private String changeContent;
    /**
     * 变更负责人
     */
    @ExcelTitleName(title = "变更负责人", order = 6)
    private String changeCommander;

    /**
     * 变更商品列表，SPUID+商品名称
     */
    @ExcelTitleName(title = "变更商品列表", order = 7)
    private String changeItems;
    /**
     * 变更供应商，仅展示供应商ID，没有时展示为“/”
     */
    @ExcelTitleName(title = "变更供应商", order = 8)
    private String supplier;
    /**
     * 变更状态
     * @see ChangeStatusEnum
     */
    @ExcelTitleName(title = "变更状态", order = 9)
    private Integer changeState;
    /**
     * 变更发起人
     */
    @ExcelTitleName(title = "变更发起人", order = 10)
    private String changeCreator;

    /**
     * 变更行动部门列表
     */
    @ExcelTitleName(title = "变更行动部门列表", order = 11)
    private String execDepartmentStrList;
    /**
     * 创建时间
     */
    @ExcelTitleName(title = "创建时间", order = 12)
    private Long createTime;

    public static List<ExcelCell> init(ChangeFlowExcelDTO dto) {
        List<ExcelCell> cellInfo = new ArrayList<>();
        ExcelCell excelCell = new ExcelCell();
        excelCell.setCellType(ExcelCellType.TEXT);
        // id
        excelCell.setValue(dto.getId());
        cellInfo.add(excelCell);
        // 变更主体
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeSubject());
        cellInfo.add(excelCell);
        // 变更类型
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeType());
        cellInfo.add(excelCell);
        // 变更负责部门名
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeDepartment());
        cellInfo.add(excelCell);
        // 变更内容
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeContent());
        cellInfo.add(excelCell);
        // 变更负责人
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeCommander());
        cellInfo.add(excelCell);
        // 变更商品列表
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeItems());
        cellInfo.add(excelCell);
        // 变更供应商
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getSupplier());
        cellInfo.add(excelCell);
        // 变更状态
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeState());
        cellInfo.add(excelCell);
        // 变更发起人
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeCreator());
        cellInfo.add(excelCell);
        // 变更行动部门列表
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getExecDepartmentStrList());
        cellInfo.add(excelCell);
        // 创建时间
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getCreateTime());
        cellInfo.add(excelCell);

        return cellInfo;
    }
}