package com.netease.mail.yanxuan.change.web.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.biz.config.AppConfig;
import com.netease.mail.yanxuan.change.biz.meta.exception.ExceptionFactory;
import com.netease.mail.yanxuan.change.common.bean.ResponseCode;
import com.netease.mail.yanxuan.change.common.bean.ResponseCodeEnum;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.SupplierInfoRsp;
import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;

import lombok.extern.slf4j.Slf4j;

/**
 * @author WangJiaXiang
 * @date 2022/12/7/007$
 */
@Slf4j
@RestController
@RequestMapping("/supplier")
public class SupplierController {

    @Autowired
    private FlowRpcSupplierService rpcSupplierService;

    @Autowired
    private AppConfig appConfig;

    @GetMapping("/query/supplier/infos")
    public AjaxResponse<List<SupplierInfoRsp>> querySupplierInfos(
        @RequestParam(name = "name", required = false) String name,
        @RequestParam(name = "uid", required = false) String uid,
        @RequestParam(name = "fuzzySearchText") String fuzzySearchText) {
        if (name == null) {
            name = appConfig.getSearchName();
        }
        if (uid == null) {
            uid = appConfig.getSearchUid();
        }
        AjaxResponse<List<SupplierInfoRsp>> supplierInfo = rpcSupplierService.getSupplierInfo(name, uid,
            fuzzySearchText);
        if (ResponseCodeEnum.SUCCESS.getCode() == (supplierInfo.getCode())) {
            return supplierInfo;
        }
        log.error("[querySupplierInfos] querySupplierInfos failed, name={},uid={},fuzzySearchText={}, errMsg={}", name,
            uid, fuzzySearchText, JSON.toJSONString(supplierInfo));
        return null;
    }

}
