/**
 * @(#)ChangeFlowCreateReq.java, 2022/11/15.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.meta.model.req;

import java.util.List;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @Author zcwang
 * @Date 2022/11/15
 */
public class ChangeFlowCreateReq {

    /**
     * 变更主体
     */
    @NotNull(message = "变更类型不能为空")
    private Integer changeSubject;


    /**
     * 一级变更类型id
     */
    @NotNull(message = "一级变更类型不能为空")
    private Integer parentChangeClassId;

    /**
     * 二级变更类型id
     */
    @NotNull(message = "二级变更类型不能为空")
    private Integer sonChangeClassId;

    /**
     * 变更商品列表
     */
    private String changeItems;

    /**
     * 变更供应商
     */
    private String changeSupplier;

    /**
     * 变更原因
     */
    @NotBlank(message = "变更原因不能为空")
    @Max(value = 500,message = "变更原因限500字")
    private String changeReason;

    /**
     * 变更内容
     */
    @NotBlank(message = "变更内容不能为空")
    @Max(value = 500,message = "变更内容限500字")
    private String changeContent;

    /**
     * 变更工单附件
     */
    private List<ChangeFlowFile> files;

    /**
     * 变更潜在风险
     */
    private String changeRiskDesc;

    /**
     * 变更收益类型
     */
    private String changeProfit;

    /**
     * 变更收益说明
     */
    @NotBlank(message = "变更收益说明不能为空")
    @Max(value = 500,message = "变更收益说明限500字")
    private String changeProfitDesc;

    /**
     * 变更结果确认时间
     */
    @NotNull(message = "变更结果确认时间不能为空")
    private Long changeConfirmResultTime;

    /**
     * 行动项
     */
    private List<ChangeExecConfigReq> changeExecProject;

    /**
     * 创建端（普通or同舟）
     */
    @NotNull(message = "创建端不能为空")
    private Integer createSource;
}