/**
 * @(#)AutoSubmit.java, 2022/11/24.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.biz.biz.ChangeFlowBiz;
import com.netease.mail.yanxuan.change.biz.service.ChangeFlowService;
import com.netease.mail.yanxuan.change.common.bean.CommonConstants;
import com.netease.mail.yanxuan.change.common.enums.ChangeFlowEnum;
import com.netease.mail.yanxuan.change.common.enums.FlowOperationTypeEnum;
import com.netease.mail.yanxuan.change.common.util.DateUtils;
import com.netease.mail.yanxuan.change.dal.entity.ChangeRecord;
import com.netease.mail.yanxuan.dschedule.core.biz.model.ReturnT;
import com.netease.mail.yanxuan.dschedule.core.handler.IJobHandler;
import com.netease.mail.yanxuan.dschedule.core.handler.annotation.JobHandler;
import com.netease.yanxuan.flowx.sdk.meta.dto.base.FlowDataDTO;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author zcwang
 * @Date 2022/11/24
 */
@Component
@Slf4j
@JobHandler("AutoSubmit")
public class AutoSubmit extends IJobHandler {

    @Autowired
    private ChangeFlowService changeFlowService;

    @Autowired
    private ChangeFlowBiz changeFlowBiz;

    @Override
    public ReturnT<String> execute(String... strings) throws Exception {
        log.info("AutoSubmit start");
        long startTime = DateUtils.getCurrentTime();
        List<Long> count = new ArrayList<>();
        Long entityId = 0L;
        // 查询今天时间之前的数据
        try {
            while (true) {
                List<ChangeRecord> records = changeFlowService.getByStatusAndTime(entityId, ChangeFlowEnum.CHANGE_FLOW_EXE.getNodeId(),
                        ChangeFlowEnum.CHANGE_FLOW_CONFIRM.getNodeId(), startTime);
                if (CollectionUtils.isEmpty(records)) {
                    break;
                }
                records.forEach(this::progressRecord);
                List<Long> idList = records.stream().map(ChangeRecord::getId).collect(Collectors.toList());
                entityId = idList.stream().max(Long::compare).get();
                count.addAll(idList);
            }
        } catch (Exception e) {
            log.error("error on AutoSubmit,e:{}", e);
        }
        log.info(
            "AutoSubmit end, count:{}, maxId:{}, usedTime:{}", count.size(), entityId, DateUtils.getCurrentTime() - startTime);
        return ReturnT.SUCCESS;
    }

    private void progressRecord(ChangeRecord changeRecord) {
        Long flowId = changeRecord.getFlowId();
        String flowNode = changeRecord.getFlowNode();
        String uid = changeRecord.getChangeCommander();
        // 执行变更节点，提交节点
        if (ChangeFlowEnum.CHANGE_FLOW_EXE.getNodeId().equals(flowNode)) {
            // 获取工单详情
            FlowDataDTO flowDataDTO = changeFlowBiz.flowDetail(flowId.toString());
            if (flowDataDTO == null) {
                log.debug("[progressRecord] get flowDataDTO error, flowId{}", flowId);
            }
            // 工单流传
            Map<String, Object> content = new HashMap<>(CommonConstants.INIT_HASH_MAP_SIZE);
            content.put("updateTime", System.currentTimeMillis());
            content.put(CommonConstants.FLOW_OPERATION_KEY, FlowOperationTypeEnum.PASS.getValue());
            try {
                String execNode = changeFlowBiz.submitFlow(flowId.toString(), flowDataDTO, uid,
                        ChangeFlowEnum.CHANGE_FLOW_EXE.getTopoId(), JSON.toJSONString(content), true);
                // 更新工单数据
                changeRecord.setFlowNode(execNode);
                changeRecord.setUpdateTime(DateUtils.getCurrentTime());
                changeFlowService.updateRecord(changeRecord);
                // todo: 发送邮件
            } catch (Exception e) {
                log.debug("[progressRecord] submit error, flowId{}", flowId);
            }
        } else if (ChangeFlowEnum.CHANGE_FLOW_CONFIRM.getNodeId().equals(flowNode)) {
            // todo: 发送邮件
        }
    }
}