CREATE TABLE `TB_YX_QC_CHANGE_CONFIG`
(
    `id`                               bigint(20) NOT NULL,
    `change_subject`                   int(255) NOT NULL COMMENT '变更主体',
    `parent_change_class_id`           int(255) NOT NULL COMMENT '一级变更类型id',
    `son_change_class_id`              int(255) NOT NULL COMMENT '二级变更类型id',
    `change_level`                     int(255) NOT NULL COMMENT '变更等级',
    `change_department`                varchar(255) NOT NULL COMMENT '变更负责部门名',
    `participate_change_exec_department` varchar(255) NOT NULL COMMENT '变更行动部门列表',
    `change_commander_type`            int(255) NOT NULL COMMENT '变更负责人类型',
    `change_commander`                 varchar(255) NOT NULL COMMENT '变更负责人详情（不同类型存储不同内容）',
    `need_file`                        int(255) NOT NULL COMMENT '是否需要资料上传',
    `create_time`                      bigint(255) NOT NULL COMMENT '创建时间',
    `update_time`                      bigint(255) NOT NULL COMMENT '更新时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='变更类型配置表';


CREATE TABLE `TB_YX_QC_CHANGE_EXEC_CONFIG`
(
    `id`                     bigint(20) NOT NULL AUTO_INCREMENT,
    `change_template_id`     bigint(255) NOT NULL COMMENT '变更类型配置记录id',
    `change_exec_department` varchar(255) NOT NULL COMMENT '变更执行部门名',
    `change_exec_user_type`  int(255) NOT NULL COMMENT '变更行动人类型',
    `change_exec_user`       varchar(255) NOT NULL COMMENT '变更行动人（不同类型存储不同内容）',
    `change_risk_desc`       varchar(255) NOT NULL COMMENT '变更风险描述',
    `change_exec_project`    varchar(255) NOT NULL COMMENT '行动项',
    `change_checking`        varchar(255) NOT NULL COMMENT '变更验证措施',
    `create_time`            bigint(255) NOT NULL COMMENT '创建时间',
    `update_time`            bigint(255) NOT NULL COMMENT '更新时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='变更类型配置行动方案配置表';

CREATE TABLE `TB_YX_QC_CHANGE_TYPE`
(
    `id`          bigint(255) NOT NULL AUTO_INCREMENT,
    `type_name`   varchar(255) NOT NULL COMMENT '类型名',
    `parent_id`   bigint(255) NOT NULL COMMENT '父类id',
    `delete`      int(255) NOT NULL COMMENT '是否删除',
    `create_time` bigint(255) NOT NULL COMMENT '创建时间',
    `update_time` bigint(255) NOT NULL COMMENT '更新时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='变更类型表';

CREATE TABLE `TB_YX_QC_CHANGE_RECORD`
(
    `id`                         bigint(20) NOT NULL AUTO_INCREMENT,
    `flow_id`                    bigint(20) NOT NULL COMMENT '工单id',
    `flow_node`                  varchar(255) NOT NULL COMMENT '工单当前节点',
    `change_subject`             int(11) NOT NULL COMMENT '变更主体',
    `parent_change_class_id`     int(11) NOT NULL COMMENT '一级变更类型id',
    `son_change_class_id`        int(11) NOT NULL COMMENT '二级变更类型id',
    `change_level`               int(11) NOT NULL COMMENT '变更等级',
    `change_commander`           varchar(20)  NOT NULL COMMENT '变更负责人',
    `change_department`varchar(20)  NOT NULL COMMENT '变更负责部门名',
    `participate_change_exec_department` varchar(255) NOT NULL COMMENT '变更行动部门列表,JSON格式',
    `change_item`                varchar(20)  NOT NULL COMMENT '变更商品（变更主体为商品时有效）',
    `change_supplier`            varchar(20)  NOT NULL COMMENT '变更供应商（变更主体为供应商时有效）',
    `change_reason`              varchar(255) NOT NULL COMMENT '变更原因',
    `change_content`             varchar(500) NOT NULL COMMENT '变更内容',
    `change_risk_desc`           varchar(255) NOT NULL COMMENT '变更潜在风险描述',
    `change_checking`            varchar(255) NOT NULL COMMENT '变更验证措施',
    `change_profit`              int(10) NOT NULL COMMENT '变更收益',
    `change_profit_desc`         varchar(255) NOT NULL COMMENT '变更收益说明',
    `change_confirm_result_time` bigint(20) NOT NULL COMMENT '变更结果确认时间',
    `state`                      int(2) NOT NULL COMMENT '工单状态',
    `is_cancel`                  int(2) NOT NULL COMMENT '是否被取消',
    `change_result`              int(2) NOT NULL COMMENT '变更结论',
    `create_source`              int(2) NOT NULL COMMENT '创建端（普通or同舟）',
    `create_supplier`            varchar(20)  NOT NULL COMMENT '创建人所属供应商（同舟创建）',
    `change_result_desc`         varchar(500) NOT NULL COMMENT '结论说明',
    `remark`                     varchar(500) NOT NULL COMMENT '备注',
    `creator`                    varchar(50)  NOT NULL COMMENT '创建人邮箱',
    `create_time`                bigint(20) NOT NULL COMMENT '创建时间',
    `update_time`                bigint(20) NOT NULL COMMENT '更新时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='变更工单记录表';

CREATE TABLE `TB_YX_QC_CHANGE_FILE`
(
    `id`               bigint(255) NOT NULL AUTO_INCREMENT,
    `change_record_id` bigint(255) NOT NULL,
    `file_type`        int(255) NOT NULL COMMENT '文件类型（基础信息图片/基础信息视频/基础信息资料/变更结果资料）',
    `file_name`        varchar(255) NOT NULL COMMENT '文件名称',
    `file_url`         varchar(255) NOT NULL COMMENT '文件地址',
    `create_time`      bigint(255) NOT NULL COMMENT '创建时间',
    `update_time`      bigint(255) NOT NULL COMMENT '更新时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='附件表';

CREATE TABLE `TB_YX_QC_CHANGE_EXEC_RECORD`
(
    `id`                      bigint(20) NOT NULL,
    `change_record_id`        bigint(20) NOT NULL COMMENT '变更记录id',
    `change_exec_department`  varchar(20)  NOT NULL COMMENT '变更执行部门名',
    `change_exec_user_type`   int(2) NOT NULL COMMENT '变更行动人类型',
    `change_exec_user`        varchar(255) NOT NULL COMMENT '变更行动人（不同类型存储不同内容）',
    `change_risk_desc`        varchar(500) NOT NULL COMMENT '变更风险描述',
    `change_exec_project`     varchar(255) NOT NULL COMMENT '行动项',
    `change_checking`         varchar(255) NOT NULL COMMENT '变更措施验证',
    `change_exec_finish_time` bigint(255) NOT NULL COMMENT '行动完成时间',
    `change_exec_finish_desc` varchar(255) NOT NULL COMMENT '行动完成情况',
    `create_time`             bigint(20) NOT NULL COMMENT '创建时间',
    `update_time`             bigint(20) NOT NULL COMMENT ' 更新时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='变更类型行动方案记录表';