/**
 * @(#)TaskCreateDTO.java, 2022/11/29.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.integration.todo;

import java.util.List;

import lombok.Data;

/**
 * @Author zcwang
 * @Date 2022/11/29
 */
@Data
public class TaskCreateDTO {

    /**
     * 待办id
     */
    private Long id;
    /**
     * 废弃
     */
    @Deprecated
    private Long taskTypeId;
    /**
     * 任务类型key
     */
    private String taskTypeKey;
    /**
     * 任务标题
     */
    private String taskTitle;
    /**
     * 任务类型名
     */
    private String taskTypeName;
    /**
     * 产品号
     */
    private String product;
    /**
     * 业务key
     */
    private String businessKey;
    /**
     * 业务数据
     */
    private String content;
    /**
     * 任务状态
     */
    private Integer taskState;
    /**
     *
     */
    private Integer taskAdvanceState;
    /**
     * 任务过期时间
     */
    private String taskOriginalExpireTime;
    /**
     * 任务过期时间
     */
    private Integer taskExpireTime;
    /**
     *
     */
    private Integer taskAdvanceTime;
    /**
     * 剩余日期
     */
    private String remainDays;
    /**
     * 处理人列表
     */
    private List<UserInfo> taskHandlerList;
    private String recentlyOperator;
    private String recentylyOperatorName;
    private String sourceRemark;
    private String creator;
    private String updator;
    private long createTime;
    private long updateTime;
    private String childTaskList;
    private String taskDetailUrl;
}