package com.netease.mail.yanxuan.change.biz.meta;



/**
 * @author lwtang
 */
public class AjaxResult<T> {

    private static final long serialVersionUID = 1L;
    private Integer code;
    private String msg;
    private T data;
    private Exception e;

    public Boolean isSuccess() {
        return this.code.equals(ResponseCodeEnum.SUCCESS.getCode());
    }

    public Boolean isFail() {
        return !this.isSuccess();
    }

    public static <R> AjaxResult<R> success() {
        return of(ResponseCodeEnum.SUCCESS);
    }

    public static <R> AjaxResult<R> success(R data) {
        return of(ResponseCodeEnum.SUCCESS).setData(data);
    }

    public static <R> AjaxResult<R> error() {
        return of(ResponseCodeEnum.INTERNAL_ERROR);
    }

    public static <R> AjaxResult<R> error(Exception e) {
        return of(ResponseCodeEnum.INTERNAL_ERROR).setE(e);
    }

    public static <R> AjaxResult<R> badRequest() {
        return of(ResponseCodeEnum.BAD_REQUEST);
    }

    public static <R> AjaxResult<R> badRequest(String msg) {
        return of(ResponseCodeEnum.BAD_REQUEST).setMsg(msg);
    }

    public static <R> AjaxResult<R> badRequest(Exception e) {
        return of(ResponseCodeEnum.BAD_REQUEST).setE(e);
    }

    public static <R> AjaxResult<R> badRequest(String msg, Exception e) {
        return of(ResponseCodeEnum.BAD_REQUEST).setMsg(msg).setE(e);
    }

    public static <R> AjaxResult<R> of(ResponseCodeEnum code) {
        return (new AjaxResult()).setCode(code.getCode()).setMsg(code.getMsg());
    }

    public static <R> AjaxResult<R> of(Integer code, String msg) {
        return (new AjaxResult()).setCode(code).setMsg(msg);
    }

    public static <R> AjaxResult<R> of(Integer code, String msg, R data) {
        return of(code, msg).setData(data);
    }

    public static <R> AjaxResult<R> of(Integer code, String msg, R data, Exception e) {
        return of(code, msg, data).setE(e);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        } else if (!(o instanceof AjaxResult)) {
            return false;
        } else {
            AjaxResult<?> other = (AjaxResult)o;
            if (!other.canEqual(this)) {
                return false;
            } else if (!super.equals(o)) {
                return false;
            } else {
                label61: {
                    Object this$code = this.getCode();
                    Object other$code = other.getCode();
                    if (this$code == null) {
                        if (other$code == null) {
                            break label61;
                        }
                    } else if (this$code.equals(other$code)) {
                        break label61;
                    }

                    return false;
                }

                label54: {
                    Object this$msg = this.getMsg();
                    Object other$msg = other.getMsg();
                    if (this$msg == null) {
                        if (other$msg == null) {
                            break label54;
                        }
                    } else if (this$msg.equals(other$msg)) {
                        break label54;
                    }

                    return false;
                }

                Object this$data = this.getData();
                Object other$data = other.getData();
                if (this$data == null) {
                    if (other$data != null) {
                        return false;
                    }
                } else if (!this$data.equals(other$data)) {
                    return false;
                }

                Object this$e = this.getE();
                Object other$e = other.getE();
                if (this$e == null) {
                    if (other$e != null) {
                        return false;
                    }
                } else if (!this$e.equals(other$e)) {
                    return false;
                }

                return true;
            }
        }
    }

    protected boolean canEqual(Object other) {
        return other instanceof AjaxResult;
    }

    public int hashCode() {
        int PRIME = true;
        int result = super.hashCode();
        Object $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        Object $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Object $e = this.getE();
        result = result * 59 + ($e == null ? 43 : $e.hashCode());
        return result;
    }

    public AjaxResult() {
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public Exception getE() {
        return this.e;
    }

    public AjaxResult<T> setCode(Integer code) {
        this.code = code;
        return this;
    }

    public AjaxResult<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public AjaxResult<T> setData(T data) {
        this.data = data;
        return this;
    }

    public AjaxResult<T> setE(Exception e) {
        this.e = e;
        return this;
    }

    public String toString() {
        return "AjaxResult(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ", e=" + this.getE() + ")";
    }
}
