/**
 * @(#)itemRpcService.java, 2022/11/30.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.service.rpc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.integration.item.CommonIdsParamQuery;
import com.netease.mail.yanxuan.change.integration.item.ItemCategoryRpcService;
import com.netease.mail.yanxuan.change.integration.item.SimplePhyCateGoryResultCo;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author zcwang
 * @Date 2022/11/30
 */
@Slf4j
@Component
public class ItemRpcService {

    @Autowired
    private ItemCategoryRpcService itemCategoryRpcService;

    /**
     * 查询物理类目
     * @param query
     * @return
     */
    public Map<Long, List<SimplePhyCateGoryResultCo>> queryCategoryChain(CommonIdsParamQuery query) {
        AjaxResult<Map<Long, List<SimplePhyCateGoryResultCo>>> response = itemCategoryRpcService.queryCategoryChain(query);
        log.info("[ItemRpcService-queryCategoryChain] response of query queryCategoryChain ={}",
                JSON.toJSONString(response));
        if (Boolean.TRUE.equals(response.isSuccess())) {
            return response.getData();
        }
        log.error("[op:rpc-queryCategoryChain] query categoryChain detail failed, query={}, errMsg={}", query,
                response.getMsg());
        return new HashMap<>();
    }
}