package com.netease.mail.yanxuan.change.common.bean;

/**
 * 返回的code
 *
 * @author lwtang
 */
public enum ResponseCode {

    //成功
    SUCCESS(200, "SUCCESS"),

    // 结果、数据为空
    EMPTY(201, "EMPTY"),

    // 处理中
    PROCESSING(202, "PROCESSING"),

    //已存在
    HAVE_EXIST(203, "用户{0}存在未完成任务"),

    //商品已售罄
    SELL_OUT(210, "SELL_OUT"),

    //已加购过该福袋
    HAVE_ADD(211, "HAVE_ADD"),

    //购物车已满
    IS_FULL(212, "IS_FULL"),

    //拥有补签卡达上限
    CARD_FULL(213, "CARD_FULL"),

    NO_TITLE_INFO(214, "标题信息缺失"),

    QUERY_FILL_CHECK_CARDS_EXCEPTION(215, "获取补签卡异常"),

    SKU_NO_EXIST(216, "skuId不存在"),

    HAVE_SIGN(217, "签到失败"),

    NO_IN_HAND_TASK(218, "没有进行中的任务"),

    NO_TASK_ID(219, "该任务不存在"),

    TASK_AWARD_HAVE_CASH(220, "任务奖励已兑换"),

    ACTIVITY_CLOSE(221, "活动关闭"),

    N0_LOTTERY(222, "无抽奖资格"),

    NO_LOTTERY_COUNT(223, "无抽奖次数"),

    LOTTERY_ERROR(224, "抽奖失败"),

    SEND_RED_PACKED_FAIL(225, "发红包失败"),

    NO_SELECT_GOOD_POWER(226,"没有选商品的资格"),

    SEND_GIFT_CARD_FAIL(227, "发福利卡失败"),

    SEND_COUPON_FAIL(228, "发优惠券失败"),

    SEND_POINT_FAIL(229, "发积分失败"),

    SEND_BACK_GOLD_FAIL(230, "发回馈金失败"),

    NO_WAIT_RECEIVE(231, "无待领取"),

    PARAM_MISS(232, "参数缺失"),

    //----------3xx-----------


    //----------4xx-----------
    //非法参数.
    BAD_REQUEST(400, "BAD REQUEST"),

    //未登录
    NOT_LOGIN(401, "NO UID"),

    //重复提交
    APPLYED(402, "APPLYED"),

    // 禁用，token验证失败等； 内部接口认证：非法访问
    FORBIDDEN(403, "FORBIDDEN"),

    // 未找到资源，具体跟业务场景有关，比如红包不存在
    NOT_FOUND(404, "NOT FOUND"),

    // 没有资格，如等级不够
    UNQULIFIED(405, "UNQULIFIED"),

    // 资源不够
    RUNOUT(406, "RUNOUT"),

    // 请求受限、余额不足
    LIMIT(407, "LIMIT"),

    //该crmId在数据库已存在
    SAME_CRM_ID(408,"该crmId在数据库已存在"),

    // 风控异常, UGC检查失败等
    RISK(411, "RISK"),

    UNIQUE_KEY(412,"唯一索引异常"),

    //----------5xx-----------
    // 服务器错误: db异常等
    SERVER_ERROR(500, "SERVER ERROR"),


    //----------others-----------
    // 限流
    RATE_LIMIT(700, "RATE_LIMIT"),

    THIRD_ERR(800, "rpc error"),

    CANT_USE(801, "激活码id 不可用"),

    NO_GOOD_TASK(802, "不是商品任务"),

    //----------10xx-----------
    CREATE_FLOW_ERROR(1001, "创建工单错误"),
    DETAIL_FLOW_ERROR(1002, "查询工单详情错误"),
    SUBMIT_FLOW_ERROR(1002, "提交工单错误"),
    ERROR_FLOW_ID(1003, "工单id不存在"),
    NODE_ERROR(1004, "工单已流转至其他节点"),
    NO_AUTH(1005, "没有当前节点操作权限"),
    CHANGE_SUBJECT_ERROR(1006, "变更主体类型错误"),
    CHANGE_TYPE_NOT_EXIST(1007, "变更类型不存在"),
    OPERATOR_NOT_EXIST(1008, "操作人不存在"),

    /**
     * 无权限
     */
    NO_PERMISSION(2001, "无权限"),

    CAN_NOT_DEL(2002, "不可删除"),

    UPDATE_FAIL(2003, "更改失败"),

    CANT_FOUND(2004, "查询不到"),

    SEND_FAIL(2005, "发送失败"),

    ACT_END(2006, "活动结束"),


    /**
     * 操作记录不存在
     */
    OP_RECORD_NOT_EXIST(3000,"opRecord id not existed"),

    /**
     * 只有操作成功才允许进行验证
     */
    ONLY_OP_SUCCESS_ALLOWED(3001,"verify only allowed when op success"),

    PARAMETER_LENGTH(413, "请检查参数长度"),

    EXEC_CONFIG_LENGTH(414, "请检查行动方案配置数量"),

    PARAMETER_DEFICIENCY(415,"参数缺失请检查参数"),

    CHANGE_TYPE_NAME_ONE(4001,"一级变更类型重复,请检查后添加~"),

    CHANGE_TYPE_NAME_TOW(4002,"二级变更类型重复,请检查后添加~");

    private int code;
    private String msg;
    ResponseCode(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public int getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
    }
