package com.netease.mail.yanxuan.change.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.netease.mail.yanxuan.change.biz.meta.exception.ExceptionFactory;
import com.netease.mail.yanxuan.change.biz.service.InteriorChangeConfigService;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeConfigService;
import com.netease.mail.yanxuan.change.common.bean.ResponseCode;
import com.netease.mail.yanxuan.change.common.enums.ChangeCommanderEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeSubjectEnum;
import com.netease.mail.yanxuan.change.dal.entity.ChangeConfig;
import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeCommanderPO;
import com.netease.mail.yanxuan.change.dal.meta.model.rpc.GoodsResponseSqeRpc;
import com.netease.mail.yanxuan.change.integration.flow.goods.ItemcenterApiRpcService;
import com.netease.mail.yanxuan.change.integration.flow.goods.PfuApiRpcService;
import com.netease.mail.yanxuan.change.integration.flow.goods.QcApiRpcService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author WangJiaXiang
 * @date 2022/11/18/018$
 */
public class InteriorChangeConfigServiceImpl implements InteriorChangeConfigService {

    @Autowired
    private ChangeConfigService changeConfigService;

    //查询商品的SQE
    @Autowired
    private QcApiRpcService qcApiRpcService;
    //查看执行人
    @Autowired
    private PfuApiRpcService pfuApiRpcService;
    //查看商品BU
    @Autowired
    private ItemcenterApiRpcService itemcenterApiRpcService;

    @Override
    public String queryCommanderInfo(ChangeCommanderPO changeCommander) {
        //获取模板名称   通过一级变更类型 二级变更类型ID 定位模板
        ChangeConfig changeConfig = changeConfigService.queryChangeConfig(changeCommander.getId());
        //查询出当前模板配置中选择的 角色
        ChangeCommanderEnum changeCommanderEnum = ChangeCommanderEnum.getChangeCommanderEnum(changeConfig.getChangeCommanderType());
        //直接排除 选项为固定人 或者发起人
        if (changeCommanderEnum.getId() == 1 || changeCommanderEnum.getId() == 2){
            return changeConfig.getChangeCommander();
        }
        ChangeSubjectEnum changeSubjectEnum = ChangeSubjectEnum.getChangeSubjectEnum(changeConfig.getChangeSubject());
        if (changeSubjectEnum.getType() == 1){
            //商品变更
            return queryGoodsCommander(changeCommanderEnum,changeCommander.getGoodsInfos(),changeConfig.getChangeCommander());
        }else if (changeSubjectEnum.getType() == 2){
            //供应商  采购 计划 SQE
            return queryChangeSupplier(changeCommanderEnum,changeCommander.getChangeSupplierId(),changeConfig.getChangeCommander());
        }
        //其他变更 备注 其他变更之后固定人 和发起人在上面判断会被排除掉
        return changeConfig.getChangeCommander();

    }

    /**
     * 商品的最终角色查询
     * @param commanderEnum   查询方向 枚举
     * @param goodsInfos  商品的列表
     * @param commander   商品的关联角色
     * @return
     */
    private String queryGoodsCommander(ChangeCommanderEnum commanderEnum,List<Long> goodsInfos,String commander){
        if (commanderEnum.getId() != 3 || goodsInfos == null || goodsInfos.size() == 0 || commander == null){
            return "类型错误 或者未选择商品";
        }
        Map<String,Integer> map = new HashMap<String,Integer>();
        //记录最大出现次数
        int temp = 0;
        //记录最大值
        String name = "";
        //记录出现的所有值
        List<String> emails = new ArrayList<String>();
        //遍历取出所有商品关联的人
        if (commander.equals("商品BU")) {
            String detail = itemcenterApiRpcService.getDetail(goodsInfos);
            getGoodsNameEmail(emails,detail);
        } else if (commander.equals("采购")) {

        } else if (commander.equals("计划")) {
            String detail = pfuApiRpcService.getDetail(goodsInfos);
            getGoodsNameEmail(emails,detail);
        } else if (commander.equals("SQE")) {
            for (Long goods:goodsInfos) {
                String detail = qcApiRpcService.getDetail(goods.intValue());
                JSONObject jsonObject = JSONObject.parseObject(detail);
                GoodsResponseSqeRpc data = jsonObject.getObject("data", GoodsResponseSqeRpc.class);
                if (data != null){
                    emails.add(data.getUserName());
                }
            }
        }
        for (String email : emails){
            if (!map.containsKey(email)){
                map.put(email,1);
            }else{
                Integer integer = map.get(email);
                ++integer;
                if (temp < integer){
                    temp = integer;
                    name = email;
                }
                map.put(email,integer);
            }
        }
        return name;
    }

    /**
     * 供应商角色最终查询
     * @param commanderEnum   查询方向 枚举
     * @param changeSupplierId 供应商信息
     * @param commander      供应商关联角色
     * @return
     */
    private String queryChangeSupplier(ChangeCommanderEnum commanderEnum,String changeSupplierId,String commander){
        if (commanderEnum.getId() != 4 || changeSupplierId == null || commander == null){
            return "返回空值 或者指示值";
        }
        //changeSupplier 根据提供的信息去查询 最终返回
        if (commander.equals("采购")){

        }else if (commander.equals("计划")){

        }else if (commander.equals("SQE")){

        }
        return null;
    }


    /**
     * 重复代码复用方法
     * @param emails 储存邮箱队列
     * @param response  请求返结果
     */
    private void getGoodsNameEmail(List<String> emails,String response){
        JSONObject jsonObject = JSONObject.parseObject(response);
        Map<String,JSONObject> rpcMap = JSONObject.parseObject(jsonObject.get("data").toString(), Map.class);
        if (rpcMap == null){
            throw ExceptionFactory.createBiz(ResponseCode.OPERATOR_NOT_EXIST);
        }
        for (String rpc : rpcMap.keySet()){
            emails.add(rpcMap.get(rpc).get("uid").toString());
        }
    }


}
