package com.netease.mail.yanxuan.change.biz.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import com.alibaba.fastjson.JSONObject;
import com.netease.mail.yanxuan.change.biz.meta.exception.ExceptionFactory;
import com.netease.mail.yanxuan.change.biz.service.InteriorChangeConfigService;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeConfigService;
import com.netease.mail.yanxuan.change.common.bean.ResponseCode;
import com.netease.mail.yanxuan.change.common.enums.ChangeCommanderEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeSubjectEnum;
import com.netease.mail.yanxuan.change.dal.entity.ChangeConfig;
import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeCommanderPO;
import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeGoodsPrincipalPO;
import com.netease.mail.yanxuan.change.dal.meta.model.rpc.CommanderResponse;
import com.netease.mail.yanxuan.change.dal.meta.model.rpc.GoodsPurchaseRpc;
import com.netease.mail.yanxuan.change.dal.meta.model.rpc.GoodsResponseRpc;
import com.netease.mail.yanxuan.change.dal.meta.model.rpc.GoodsResponseSqeRpc;
import com.netease.mail.yanxuan.change.integration.flow.goods.ItemcenterApiRpcService;
import com.netease.mail.yanxuan.change.integration.flow.goods.PfuApiRpcService;
import com.netease.mail.yanxuan.change.integration.flow.goods.QcApiRpcService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierSendService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierRelatedUserReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.SupplierUserRsp;
import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;

/**
 * @author WangJiaXiang
 * @date 2022/11/18/018$
 */
@Service
public class InteriorChangeConfigServiceImpl implements InteriorChangeConfigService {

    private static Logger logger = LoggerFactory.getLogger(InteriorChangeConfigServiceImpl.class);

    @Autowired
    private ChangeConfigService changeConfigService;

    //查询商品的SQE
    @Autowired
    private QcApiRpcService qcApiRpcService;
    //查看执行人
    @Autowired
    private PfuApiRpcService pfuApiRpcService;
    //查看商品BU
    @Autowired
    private ItemcenterApiRpcService itemcenterApiRpcService;
    @Autowired
    private FlowRpcSupplierSendService supplierSendService;

    /**
     * 接口不完整,关于商品的查询已经完成  供应商查询不完整接口已对接 具体返回值接口测试未完成
     * @param changeCommander
     * @return
     */
    @Override
    public GoodsResponseRpc queryCommanderInfo(ChangeCommanderPO changeCommander) {
        GoodsResponseRpc rpc = new GoodsResponseRpc();
        //获取模板名称   通过一级变更类型 二级变更类型ID 定位模板
        ChangeConfig changeConfig = changeConfigService.queryChangeType(changeCommander.getParentChangeClassId(), changeCommander.getSonChangeClassId());
        if (changeConfig == null){
            return null;
        }
        //查询出当前模板配置中选择的 角色
        ChangeCommanderEnum changeCommanderEnum = ChangeCommanderEnum.getChangeCommanderEnum(changeConfig.getChangeCommanderType());
        //直接排除 选项为固定人 或者发起人
        if (changeCommanderEnum.getId() == 1 || changeCommanderEnum.getId() == 2){
            //固定人或者发起人;
            rpc.setEmail(changeConfig.getChangeCommander());
            return rpc;
        }
        ChangeSubjectEnum changeSubjectEnum = ChangeSubjectEnum.getChangeSubjectEnum(changeConfig.getChangeSubject());
        if (changeSubjectEnum.getType() == 1){
            //商品变更
            return queryGoodsCommander(changeCommanderEnum,changeCommander.getGoodsInfos(),changeConfig.getChangeCommander());
        }else if (changeSubjectEnum.getType() == 2){
            //供应商  采购 计划 SQE
            return queryChangeSupplier(changeCommanderEnum,changeCommander.getChangeSupplierId(),changeConfig.getChangeCommander());
        }
        //其他变更 备注 其他变更之后固定人 和发起人在上面判断会被排除掉     changeConfig.getChangeCommander();
        return null;
    }

    /**
     * 商品的最终角色查询
     * @param commanderEnum   查询方向 枚举
     * @param goodsInfos  商品的列表
     * @param commander   商品的关联角色
     * @return
     */
    public GoodsResponseRpc queryGoodsCommander(ChangeCommanderEnum commanderEnum,List<Long> goodsInfos,String commander){
        if (commanderEnum.getId() != 3 || goodsInfos == null || goodsInfos.size() == 0 || commander == null){
            return null;
        }
        Map<String,GoodsResponseRpc> map = new HashMap<String,GoodsResponseRpc>();
        //记录最大出现次数
        int temp = 0;
        //记录最大值
        GoodsResponseRpc name = new GoodsResponseRpc();
        //记录出现的所有值
        List<GoodsResponseRpc> emails = new ArrayList<GoodsResponseRpc>();
        //遍历取出所有商品关联的人
        if (commander.equals("商品BU")) {
            String detail = itemcenterApiRpcService.getDetail(goodsInfos);
            logger.error("根据商品查看商品负责BU接口返回值\t"+detail);
            getGoodsNameEmail(emails,detail);
        } else if (commander.equals("采购")) {
            //采购返回值处理逻辑
            String detail = supplierSendService.queryGoodsPurchase(goodsInfos);
            logger.error("根据商品查看商品负责采购接口返回值\t"+detail);
            JSONObject jsonObject = JSONObject.parseObject(detail);
            List<GoodsPurchaseRpc> purchaseRpcs = JSONObject.parseArray(jsonObject.get("data").toString(), GoodsPurchaseRpc.class);
            for (GoodsPurchaseRpc purchaseRpc : purchaseRpcs){
                GoodsResponseRpc goodsRpc = new GoodsResponseRpc();
                goodsRpc.setEmail(purchaseRpc.getSupplierTraceBusiness());
                goodsRpc.setName(purchaseRpc.getSupplierName());
                emails.add(goodsRpc);
            }
        } else if (commander.equals("计划")) {
            String detail = pfuApiRpcService.getDetail(goodsInfos);
            logger.error("根据商品查看商品负责计划接口返回值\t"+detail);
            getGoodsNameEmail(emails,detail);
        } else if (commander.equals("SQE")) {
            for (Long goods:goodsInfos) {
                String detail = qcApiRpcService.getDetail(goods.intValue());
                logger.error("根据商品查看商品负责SQE接口返回值\t"+detail);
                JSONObject jsonObject = JSONObject.parseObject(detail);
                GoodsResponseSqeRpc data = jsonObject.getObject("data", GoodsResponseSqeRpc.class);
                if (data != null){
                    //需要验证返回值 是否正确
                    GoodsResponseRpc rpc = new GoodsResponseRpc();
                    rpc.setEmail(data.getUserName());
                    rpc.setName(data.getRealName());
                    emails.add(rpc);
                }
            }
        }
        //逻辑发生变更
        for (GoodsResponseRpc email : emails){
            if (!map.containsKey(email.getName())){
                email.setOccurrenceNumber(1);
            }else{
                GoodsResponseRpc goodsResponseRpc = map.get(email.getName());
                email.setOccurrenceNumber(goodsResponseRpc.getOccurrenceNumber()+1);
                if (temp < goodsResponseRpc.getOccurrenceNumber()){
                    temp = goodsResponseRpc.getOccurrenceNumber();
                    name = goodsResponseRpc;
                }
            }
            map.put(email.getName(),email);
        }
        if (name.getName() == null){
            Iterator<GoodsResponseRpc> iterator = map.values().iterator();
            name = iterator.next();
        }
        return name;
    }



    /**
     * 供应商角色最终查询
     * @param commanderEnum   查询方向 枚举
     * @param changeSupplierId 供应商信息
     * @param commander      供应商关联角色
     * @return
     */
    private GoodsResponseRpc queryChangeSupplier(ChangeCommanderEnum commanderEnum,String changeSupplierId,String commander){
        GoodsResponseRpc rpc = new GoodsResponseRpc();
        if (commanderEnum.getId() != ChangeCommanderEnum.SUPPLIERS_ASSOCIATED.getId() || changeSupplierId == null || commander == null){
            return null;
        }
        SupplierRelatedUserReq req = new SupplierRelatedUserReq();
        List<String> supplierIdList = new ArrayList<>();
        supplierIdList.add(changeSupplierId);
        //changeSupplier 根据提供的信息去查询 最终返回
        if (commander.equals("采购")){
            req.setSearchType(1);
        }else if (commander.equals("计划")){
            req.setSearchType(2);
        }else if (commander.equals("SQE")){
            req.setSearchType(3);
        }
        req.setSupplierIdList(supplierIdList);
        //进行参数解析
        AjaxResponse<List<SupplierUserRsp>> listAjaxResponse = supplierSendService.querySupplierRelatedUser(req);
        List<SupplierUserRsp> data = listAjaxResponse.getData();
        if (data != null){
            // 返回结果有问题暂时不动
            //rpc.setSupplierId();
        }
        return null;
    }


    /**
     * 重复代码复用方法
     * @param emails 储存邮箱队列
     * @param response  请求返结果
     */
    private void getGoodsNameEmail(List<GoodsResponseRpc> emails,String response){
        JSONObject jsonObject = JSONObject.parseObject(response);
        Map<String,JSONObject> rpcMap = JSONObject.parseObject(jsonObject.get("data").toString(), Map.class);
        if (rpcMap == null){
            throw ExceptionFactory.createBiz(ResponseCode.OPERATOR_NOT_EXIST);
        }
        for (String rpc : rpcMap.keySet()){
            GoodsResponseRpc goodsRpc = new GoodsResponseRpc();
            goodsRpc.setEmail(rpcMap.get(rpc).get("uid").toString());
            goodsRpc.setName(rpcMap.get(rpc).get("name").toString());
            emails.add(goodsRpc);
        }
    }

    @Override
    public Map<Long, ChangeGoodsPrincipalPO> queryGoodsPrincipalInfo(List<Long> itemIds){
        Map<Long, ChangeGoodsPrincipalPO> map = new HashMap<>();
        for (Long itemId : itemIds){
            map.put(itemId,new ChangeGoodsPrincipalPO());
        }
        //商品BU
        String functionary = itemcenterApiRpcService.getDetail(itemIds);
        logger.error("请求商品BU结果"+functionary);
        getGoodsPrincipalNameEmail(1,map,functionary);
        //计划
        String project = pfuApiRpcService.getDetail(itemIds);
        logger.error("请求商品计划结果"+project);
        getGoodsPrincipalNameEmail(2,map,project);
        //商品采购
        String GoodsPurchase = supplierSendService.queryGoodsPurchase(itemIds);
        JSONObject jsonObject = JSONObject.parseObject(GoodsPurchase);
        List<GoodsPurchaseRpc> purchaseRpcs = JSONObject.parseArray(jsonObject.get("data").toString(), GoodsPurchaseRpc.class);
        for (GoodsPurchaseRpc rpc: purchaseRpcs){
            map.get(rpc.getItemId().longValue()).setPurchaseName(rpc.getSupplierName());
            map.get(rpc.getItemId().longValue()).setPurchaseEmail(rpc.getSupplierTraceBusiness());
        }
        //SQE
        for(Long itemId : itemIds){
            String sqe = qcApiRpcService.getDetail(itemId.intValue());
            logger.error("根据商品查看商品负责SQE接口返回值\t"+sqe);
            JSONObject jsonObject1 = JSONObject.parseObject(sqe);
            GoodsResponseSqeRpc data = jsonObject1.getObject("data", GoodsResponseSqeRpc.class);
            if (data != null){
                //需要验证返回值 是否正确
                map.get(itemId).setGoodsSqeName(data.getRealName());
                map.get(itemId).setGoodsSqeEmail(data.getUserName());
            }
        }
        return map;
    }

    @Override
    public CommanderResponse queryCommanderEmail(Integer changeExecUserType, String changeExecUser, String uid) {
        ChangeCommanderEnum changeCommanderEnum = ChangeCommanderEnum.getChangeCommanderEnum(changeExecUserType);
        Assert.notNull(changeCommanderEnum, "变更负责人类型错误");
        CommanderResponse commanderResponse= new CommanderResponse();
        switch (changeCommanderEnum) {
            case COMMANDER_ORIGINATOR:
                commanderResponse.setEmail(uid);
                break;
            case FIXED_PERSON:
                commanderResponse.setEmail(changeExecUser);
                break;
            case GOODS_ASSOCIATED:

        }
        return null;
    }

    /**
     * 请求数据解析以及装载
     * @param type 1:BU  2:计划
     * @param map
     * @param response
     */
    private void getGoodsPrincipalNameEmail(Integer type,Map<Long, ChangeGoodsPrincipalPO> map,String response){
        JSONObject jsonObject = JSONObject.parseObject(response);
        Map<String,JSONObject> rpcMap = JSONObject.parseObject(jsonObject.get("data").toString(), Map.class);
        if (rpcMap == null){
            throw ExceptionFactory.createBiz(ResponseCode.OPERATOR_NOT_EXIST);
        }
        for (String rpc : rpcMap.keySet()){
            ChangeGoodsPrincipalPO goodsRpc = map.get(Long.parseLong(rpc));
            if (type == 1){
                goodsRpc.setFunctionaryName(rpcMap.get(rpc).get("uid").toString());
                goodsRpc.setFunctionaryEmail(rpcMap.get(rpc).get("name").toString());
            }else {
                goodsRpc.setGoodsProjectName(rpcMap.get(rpc).get("uid").toString());
                goodsRpc.setGoodsProjectEmail(rpcMap.get(rpc).get("name").toString());
            }
        }
    }

}
