/**
 * @(#)ChangeFlowBiz.java, 2022/11/15.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.biz;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import com.netease.mail.yanxuan.change.biz.service.ChangeFlowService;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeConfigService;
import com.netease.mail.yanxuan.change.common.enums.ChangeStatusEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeSubjectEnum;
import com.netease.mail.yanxuan.change.common.enums.NeedFileEnum;
import com.netease.mail.yanxuan.change.common.util.DateUtils;
import com.netease.mail.yanxuan.change.dal.entity.ChangeConfig;
import com.netease.mail.yanxuan.change.dal.entity.ChangeRecord;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowCreateReq;

/**
 * @Author zcwang
 * @Date 2022/11/15
 */
@Component
public class ChangeFlowBiz {

    @Autowired
    private ChangeConfigService changeConfigService;

    @Autowired
    private ChangeFlowService changeFlowService;

    public Boolean createAndSubmit(ChangeFlowCreateReq changeFlowCreateReq) {

        // 校验变更主体
        Boolean containsChangeSubject = ChangeSubjectEnum.getByType(changeFlowCreateReq.getChangeSubject());
        Assert.isTrue(containsChangeSubject, "变更主体不存在");

        // 检验是否需要资料
        ChangeConfig changeConfig = changeConfigService.queryChangeConfig(changeFlowCreateReq.getSonChangeClassId());
        Assert.notNull(changeConfig, "二级变更类型不存在");
        Integer needFile = changeConfig.getNeedFile();
        if (NeedFileEnum.NEED.getStatus().equals(needFile)) {
            Assert.notEmpty(changeFlowCreateReq.getFiles(), "必须上传资料");
        }

        // 创建并提交工作流

        // 保存工单数据
        ChangeRecord record = buildRecord(changeFlowCreateReq);
        changeFlowService.saveRecord(record);
        return null;
    }

    private ChangeRecord buildRecord(ChangeFlowCreateReq changeFlowCreateReq) {
        ChangeRecord changeRecord = new ChangeRecord();
        // todo
        changeRecord.setFlowId(null);
        // todo
        changeRecord.setFlowNode(null);
        changeRecord.setChangeSubject(changeFlowCreateReq.getChangeSubject());
        changeRecord.setParentChangeClassId(changeFlowCreateReq.getParentChangeClassId());
        changeRecord.setSonChangeClassId(changeFlowCreateReq.getSonChangeClassId());
        // todo: 变更负责人
        changeRecord.setChangeCommander(null);
        changeRecord.setChangeItem(changeFlowCreateReq.getChangeItems());
        changeRecord.setChangeSupplier(changeFlowCreateReq.getChangeSupplier());
        changeRecord.setChangeReason(changeFlowCreateReq.getChangeReason());
        changeRecord.setChangeContent(changeFlowCreateReq.getChangeContent());
        changeRecord.setChangeRiskDesc(changeFlowCreateReq.getChangeRiskDesc());
        changeRecord.setChangeProfit(changeFlowCreateReq.getChangeProfit());
        changeRecord.setChangeProfitDesc(changeFlowCreateReq.getChangeProfitDesc());
        changeRecord.setChangeConfirmResultTime(changeFlowCreateReq.getChangeConfirmResultTime());
        // todo: 工单状态
        changeRecord.setState(ChangeStatusEnum.IN.getStatus());
        // todo：工单是否被取消
        changeRecord.setIsCancel(0);
        // 变更结论
        changeRecord.setChangeResult(null);
        changeRecord.setCreateSource(changeFlowCreateReq.getCreateSource());
        changeRecord.setCreateSupplier(changeFlowCreateReq.getChangeSupplier());
        changeRecord.setChangeResultDesc("");
        changeRecord.setRemark("");
        changeRecord.setCreator(null);
        changeRecord.setCreateTime(DateUtils.getCurrentTime());
        changeRecord.setUpdateTime(DateUtils.getCurrentTime());
        return changeRecord;
    }
}