/**
 * @(#)itemRpcService.java, 2022/11/30.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.service.rpc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.integration.item.ItemCategoryRpcService;
import com.netease.mail.yanxuan.change.integration.item.SimplePhyCateGoryResultCo;
import com.netease.mail.yanxuan.change.integration.item.meta.SpuTO;
import com.netease.mail.yanxuan.change.integration.item.param.BatchQuerySpuInfoParam;
import com.netease.mail.yanxuan.change.integration.item.param.CommonIdsParamQuery;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author zcwang
 * @Date 2022/11/30
 */
@Slf4j
@Component
public class ItemRpcService {

    @Autowired
    private ItemCategoryRpcService itemCategoryRpcService;

    /**
     * 查询物理类目
     * 
     * @param query
     * @return
     */
    public Map<Long, List<SimplePhyCateGoryResultCo>> queryCategoryChain(CommonIdsParamQuery query) {
        log.info("[ItemRpcService-queryCategoryChain] request of query={}",
                JSON.toJSONString(query));
        AjaxResult<Map<Long, List<SimplePhyCateGoryResultCo>>> response = itemCategoryRpcService
            .queryCategoryChain(query);
        log.info("[ItemRpcService-queryCategoryChain] response of query queryCategoryChain ={}",
            JSON.toJSONString(response));
        if (Boolean.TRUE.equals(response.isSuccess())) {
            return response.getData();
        }
        log.error("[op:rpc-queryCategoryChain] query categoryChain detail failed, query={}, errMsg={}", query,
            response.getMsg());
        return new HashMap<>();
    }

    public List<SpuTO> batchQuerySpuInfo(BatchQuerySpuInfoParam query) {
        log.info("[ItemRpcService-batchQuerySpuInfo] request of query={}",
                JSON.toJSONString(query));
        AjaxResult<List<SpuTO>> response = itemCategoryRpcService.batchQuerySpuInfo(query);
        log.info("[ItemRpcService-batchQuerySpuInfo] response of query batchQuerySpuInfo ={}",
                JSON.toJSONString(response));
        if (Boolean.TRUE.equals(response.isSuccess())) {
            return response.getData();
        }
        log.error("[op:rpc-batchQuerySpuInfo] query batchQuerySpuInfo failed, query={}, errMsg={}", query,
                response.getMsg());
        return new ArrayList<>();
    }
}
