package com.netease.mail.yanxuan.change.integration.email.email;

import org.assertj.core.util.Lists;
import lombok.SneakyThrows;
import org.springframework.beans.BeanUtils;

import java.util.ArrayList;
import java.util.List;

public class BaseConvertor {
    @SneakyThrows
    public static <T> T convert(Object object, final Class<T> clazz) {
        if (object == null) {
            return null;
        }
        T t = clazz.newInstance();
        BeanUtils.copyProperties(object, t);
        return t;
    }

    @SneakyThrows
    public static void copyProperties(Object source, Object target) {
        BeanUtils.copyProperties(source, target);
    }

    @SneakyThrows
    public static <T> List<T> convert(List<?> objects, final Class<T> clazz) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(objects)) {
            return new ArrayList<>();
        }
        List<T> retList = Lists.newArrayList();
        objects.forEach(object -> {
            try {
                T t = clazz.newInstance();
                BeanUtils.copyProperties(object, t);
                retList.add(t);
            } catch (Exception ex) {
                try {
                    throw  ex;
                } catch (InstantiationException e) {
                    e.printStackTrace();
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        });
        return retList;
    }
}
