package com.netease.mail.yanxuan.change.integration.email.service.impl;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.netease.mail.yanxuan.change.common.bean.ResponseCode;
import com.netease.mail.yanxuan.change.integration.email.service.IUasEhcClient;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.netease.mail.yanxuan.qc.service.client.utils.http.HttpClientExecutor;
import com.netease.yanxuan.sc.guard.lib.meta.enums.guard.Type;

@Service
public class IUasClientEhcImpl implements IUasEhcClient {

    private static final String PUSH_EMAIL = "/push/email/yanxuan-sc-ehc";

    public static final String CODE = "code";

    private Logger logger = LoggerFactory.getLogger(EmailEhcServiceImpl.class);

    @Autowired
    private HttpClientExecutor httpClientExecutor;

    @Value("${rpc.url.uas.basic}")
    private String uasUrl;

    @Override
    public void sendEmail(String subject, String content, Collection<String> toList, Collection<String> ccList,
        List<File> fileList) {
        if (!CollectionUtils.isEmpty(toList)) {
            String url = uasUrl + PUSH_EMAIL;
            Map<String, String> params = new HashMap();
            params.put("subject", subject);
            params.put("content", content);
            if (!CollectionUtils.isEmpty(toList)) {
                params.put("to", StringUtils.join(toList, ","));
            }
            params.put("topic", "ehc");
            if (!CollectionUtils.isEmpty(ccList)) {
                params.put("cc", StringUtils.join(ccList, ","));
            }
            String res = null;
            try {
                res = this.httpClientExecutor.doPost(url, params);
            } catch (Exception e) {
                logger.error("[sendEmail] params={}, e={}", JSON.toJSONString(params), e);
            }
            this.logger.info("[sendEmail] toList={}, ccList={}, params={}, res={} ", JSON.toJSONString(toList),
                JSON.toJSONString(ccList), JSON.toJSONString(params), JSON.toJSONString(res));
            JSONObject jsonObject = JSON.parseObject(res);
            if (jsonObject.getInteger(CODE) != ResponseCode.SUCCESS.getCode()) {
                this.logger.error(Type.RPC.toString(), "SendEmail",  null,
                    "send email failed, subject={},toList={},ccList={}",
                    new Object[] { subject, JSON.toJSONString(toList), JSON.toJSONString(ccList) });
            }
        }
    }
}
