package com.netease.mail.yanxuan.change.integration.email.service.impl;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.netease.mail.yanxuan.change.common.bean.ResponseCode;
import com.netease.mail.yanxuan.change.integration.email.service.IUasEhcClient;
import com.netease.mail.yanxuan.change.integration.flow.email.EmailRpcService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

@Service
public class IUasClientEhcImpl implements IUasEhcClient {

    //请求地址   http://127.0.0.1:8550/proxy/online.logistics-uas.service.mailsaas/push/email/yanxuan-sc-ehc

    public static final String CODE = "code";

    private Logger logger = LoggerFactory.getLogger(IUasClientEhcImpl.class);

    @Autowired
    private EmailRpcService rpcService;

    @Override
    public void sendEmail(String subject, String content, Collection<String> toList, Collection<String> ccList,
        List<File> fileList) {
        if (!CollectionUtils.isEmpty(toList)) {
            Map<String, String> params = new HashMap();
            logger.error("参数查看"+subject);
            if (subject == null || subject.equals("")){
                subject = "测试标题";
            }
            params.put("subject", subject);
            params.put("content", content);
            if (!CollectionUtils.isEmpty(toList)) {
                params.put("to", StringUtils.join(toList, ","));
            }
            params.put("topic", "ehc");
            if (!CollectionUtils.isEmpty(ccList)) {
                params.put("cc", StringUtils.join(ccList, ","));
            }
            String res = null;
            try {
                res = this.rpcService.sendEmailInfo(params);
            } catch (Exception e) {
                logger.error("[sendEmail] params={}, e={}", JSON.toJSONString(params), e);
            }
            this.logger.info("[sendEmail] toList={}, ccList={}, params={}, res={} ", JSON.toJSONString(toList),
                JSON.toJSONString(ccList), JSON.toJSONString(params), JSON.toJSONString(res));
            JSONObject jsonObject = JSON.parseObject(res);
            if (jsonObject.getInteger(CODE) != ResponseCode.SUCCESS.getCode()) {
                this.logger.error("SendEmail",  null,
                    "send email failed, subject={},toList={},ccList={}",
                    new Object[] { subject, JSON.toJSONString(toList), JSON.toJSONString(ccList) });
            }
        }
    }
}

