/**
 * @(#)ChangeFlowVO.java, 2022/11/14.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.meta.model.vo;

import java.util.List;

import com.netease.mail.yanxuan.change.common.enums.ChangeStatusEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeSubjectEnum;
import com.netease.mail.yanxuan.change.dal.entity.ChangeExecRecord;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowFile;

import lombok.Builder;
import lombok.Data;

/**
 * @Author zcwang
 * @Date 2022/11/14
 */

@Data
public class ChangeFlowVO {

    private Long id;

    /**
     * 工单id
     */
    private Long flowId;
    /**
     * 变更主体
     * @see ChangeSubjectEnum
     */
    private Integer changeSubject;
    /**
     * 变更类型，一级类型>二级类型
     */
    private String changeType;

    /**
     * 变更等级
     */
    private Integer changeLevel;

    /**
     * 变更负责部门名
     */
    private String changeDepartment;

    /**
     * 变更原因
     */
    private String changeReason;

    /**
     * 变更内容
     */
    private String changeContent;
    /**
     * 变更负责人
     */
    private String changeCommander;

    /**
     * 变更潜在风险描述
     */
    private String changeRiskDesc;

    /**
     * 附件
     */
    private List<ChangeFlowFile> files;

    /**
     * 变更收益类型
     */
    private Integer changeProfit;

    /**
     * 变更收益说明
     */
    private String changeProfitDesc;
    /**
     * 变更商品列表
     */
    private String changeItems;
    /**
     * 变更供应商
     */
    private String supplier;
    /**
     * 变更状态
     * @see ChangeStatusEnum
     */
    private Integer changeState;
    /**
     * 变更发起人
     */
    private String changeCreator;
    /**
     * 变更行动部门
     */
    private List<ChangeFlowExecVO> changeExecDepartment;
    /**
     * 创建时间
     */
    private Long createTime;

    /**
     * 变更结果确认时间
     */
    private Long changeConfirmResultTime;

    /**
     * 工单状态
     */
    private Integer state;

    /**
     * 取消原因
     */
    private String cancelReason;

    /**
     * 变更结论
     */
    private Integer changeResult;

    /**
     * 备注
     */
    private String remark;
}