package com.netease.mail.yanxuan.change.biz.service.impl;

import com.netease.mail.yanxuan.change.biz.service.change.ChangeConfigService;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeExecConfigService;
import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.netease.mail.yanxuan.change.biz.service.AdminChangeConfigService;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeTypeService;
import com.netease.mail.yanxuan.change.common.bean.ResponseCodeEnum;
import com.netease.mail.yanxuan.change.dal.entity.ChangeConfig;
import com.netease.mail.yanxuan.change.dal.entity.ChangeExecConfig;
import com.netease.mail.yanxuan.change.dal.entity.ChangeType;
import com.netease.mail.yanxuan.change.dal.mapper.ChangeConfigMapper;
import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeConfigPo;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeConfigQueryReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeConfigReq;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.ChangeConfigVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;

/**
 * @author WangJiaXiang
 * @date 2022/11/11/011$
 */
@Service
public class AdminChangeConfigServiceImpl implements AdminChangeConfigService {

    @Autowired
    public ChangeConfigMapper mapper;

    @Autowired
    private ChangeTypeService typeService;

    @Autowired
    private ChangeConfigService changeConfigService;

    @Autowired
    private ChangeExecConfigService execConfigService;

    @Override
    public AjaxResult queryChanges(Integer pageNum, Integer pageSize, ChangeConfigQueryReq req) {
        //进行分页
        PageHelper.startPage(pageNum,pageSize);
        List<ChangeConfigPo> changeConfigPos = mapper.selectChangeConfigPo(req);
        PageInfo<ChangeConfigPo> pageInfo = new PageInfo<>(changeConfigPos);
        return AjaxResult.success(pageInfo);
    }

    @Override
    public AjaxResult queryDetail(Long id, Long sonChangeClassId) {
        if (id == null || sonChangeClassId == null){
            return AjaxResult.of(ResponseCodeEnum.PARAM_ERROR);
        }
        //尝试从reids里面 获取 如果获取到了直接返回


        //从数据库中取出数据
        ChangeConfig changeConfig = changeConfigService.queryChangeConfig(id);
        if (changeConfig == null){
            return AjaxResult.of(ResponseCodeEnum.NO_FOUND);
        }
        List<ChangeType> changeTypes = typeService.queryChangeType(changeConfig.getParentChangeClassId(), changeConfig.getSonChangeClassId(), true);
        if (changeTypes == null || changeTypes.size() != 2){
            return AjaxResult.of(ResponseCodeEnum.NO_FOUND);
        }
        List<ChangeExecConfig> changeExecConfigs = execConfigService.queryChangeExecConfig(id);
        if (changeExecConfigs == null || changeExecConfigs.size() == 0){
            return AjaxResult.of(ResponseCodeEnum.NO_FOUND);
        }
        //组装数据
        ChangeConfigVO vo = new ChangeConfigVO();
        vo.setChangeConfig(changeConfig);
        vo.setChangeTypes(changeTypes);
        vo.setChangeExecConfigs(changeExecConfigs);
        //放入缓存并返回
        return AjaxResult.success(vo);
    }

    @Override
    public AjaxResult createChange(ChangeConfigReq changeConfigReq) {
        //一级类目  二级类目 都不可重复    一级类目与二级类目的关联关系是一对一关联  如果有重复的话就使用返回值提示重复
        return null;
    }

    @Override
    public AjaxResult modifyChange(ChangeConfigReq changeConfigReq) {
        //新增类似   //内嵌行动方案
        return null;
    }

    @Override
    public AjaxResult deleteChange(Long id) {
        //删除 变更配置 行动方案  缓存内删除
        //变更类型表数据信息伪删
        return null;
    }

    /**
     * 二级目录类型查询出所有一级二级
     *
     * @return
     */
    @Override
    public AjaxResult queryConfigType() {
        return AjaxResult.success(typeService.queryConfigType());
    }
}
