/**
 * @(#)ChangeFlowBiz.java, 2022/11/15.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.biz;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.netease.mail.yanxuan.change.biz.config.AppConfig;
import com.netease.mail.yanxuan.change.biz.meta.exception.ExceptionFactory;
import com.netease.mail.yanxuan.change.biz.service.ChangeFileService;
import com.netease.mail.yanxuan.change.biz.service.ChangeFlowExecService;
import com.netease.mail.yanxuan.change.biz.service.ChangeFlowService;
import com.netease.mail.yanxuan.change.biz.service.InteriorChangeConfigService;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeConfigService;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeTypeService;
import com.netease.mail.yanxuan.change.biz.service.rpc.FlowService;
import com.netease.mail.yanxuan.change.biz.service.rpc.ItemService;
import com.netease.mail.yanxuan.change.biz.service.rpc.IusService;
import com.netease.mail.yanxuan.change.biz.service.rpc.SupplierSendService;
import com.netease.mail.yanxuan.change.biz.service.rpc.TodoService;
import com.netease.mail.yanxuan.change.common.bean.CommonConstants;
import com.netease.mail.yanxuan.change.common.bean.RequestLocalBean;
import com.netease.mail.yanxuan.change.common.bean.ResponseCode;
import com.netease.mail.yanxuan.change.common.enums.ChangeFlowEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeResultEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeStatusEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeSubjectEnum;
import com.netease.mail.yanxuan.change.common.enums.CreateSourceEnum;
import com.netease.mail.yanxuan.change.common.enums.FileTypeEnum;
import com.netease.mail.yanxuan.change.common.enums.FlowOperationTypeEnum;
import com.netease.mail.yanxuan.change.common.enums.FlowxOperationEnum;
import com.netease.mail.yanxuan.change.common.enums.NeedFileEnum;
import com.netease.mail.yanxuan.change.common.enums.OperateTypeEnum;
import com.netease.mail.yanxuan.change.common.util.DateUtils;
import com.netease.mail.yanxuan.change.dal.entity.ChangeConfig;
import com.netease.mail.yanxuan.change.dal.entity.ChangeExecRecord;
import com.netease.mail.yanxuan.change.dal.entity.ChangeFile;
import com.netease.mail.yanxuan.change.dal.entity.ChangeRecord;
import com.netease.mail.yanxuan.change.dal.entity.ChangeType;
import com.netease.mail.yanxuan.change.dal.mapper.ChangeRecordMapper;
import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeCommanderPO;
import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeConfigPo;
import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeGoodsPrincipalPO;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeExecConfigReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowCancelReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowCreateReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowDeliverReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowFile;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowListQueryReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowSubmitReq;
import com.netease.mail.yanxuan.change.dal.meta.model.rpc.GoodsResponseRpc;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.BasicChangeFlowVO;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.CategoryInfoVO;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.ChangeFlowExecVO;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.ChangeFlowListVO;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.ChangeFlowVO;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.ItemBasicInfoVO;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.ItemVO;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.PageVO;
import com.netease.mail.yanxuan.change.integration.email.enums.EmailTemplateEnum;
import com.netease.mail.yanxuan.change.integration.email.service.IEmailService;
import com.netease.mail.yanxuan.change.integration.excel.ChangeFlowExcelDTO;
import com.netease.mail.yanxuan.change.integration.flow.ius.req.IusDepartmentReq;
import com.netease.mail.yanxuan.change.integration.flow.ius.rsp.SecondaryDepartments;
import com.netease.mail.yanxuan.change.integration.item.SimplePhyCateGoryResultCo;
import com.netease.mail.yanxuan.change.integration.item.meta.SpuTO;
import com.netease.mail.yanxuan.change.integration.item.param.BatchQuerySpuInfoParam;
import com.netease.mail.yanxuan.change.integration.item.param.CommonIdsParamQuery;
import com.netease.mail.yanxuan.change.integration.todo.TaskCreateDTO;
import com.netease.yanxuan.flowx.sdk.meta.dto.base.FlowDataDTO;
import com.netease.yanxuan.flowx.sdk.meta.dto.base.UserBaseDTO;
import com.netease.yanxuan.flowx.sdk.meta.dto.base.UserReachDTO;
import com.netease.yanxuan.flowx.sdk.meta.dto.exec.InterfaceInputDTO;
import com.netease.yanxuan.flowx.sdk.meta.dto.exec.UserBaseContainerDTO;
import com.netease.yanxuan.flowx.sdk.meta.dto.flow.FlowCreateReqDTO;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import lombok.extern.slf4j.Slf4j;

/**
 * @Author zcwang
 * @Date 2022/11/15
 */
@Component
@Slf4j
public class ChangeFlowBiz {

    @Autowired
    private ChangeConfigService changeConfigService;

    @Autowired
    private ChangeTypeService changeTypeService;

    @Autowired
    private ChangeFlowService changeFlowService;

    @Autowired
    private AppConfig appConfig;

    @Autowired
    private FlowService flowService;

    @Autowired
    private ChangeFileService changeFileService;

    @Autowired
    private ChangeFlowExecService changeFlowExecService;

    @Autowired
    private ChangeRecordMapper changeRecordMapper;

    @Autowired
    private TodoService todoService;

    @Autowired
    private ItemService itemService;

    @Autowired
    private InteriorChangeConfigService interiorChangeConfigService;

    @Autowired
    private IEmailService iEmailService;

    @Autowired
    private IusService iusService;

    @Autowired
    private SupplierSendService sendSupplierEmail;

    public String createAndSubmit(ChangeFlowCreateReq changeFlowCreateReq) {
        String uid = RequestLocalBean.getUid();
        log.info("[create] createReq={}, uid:{}", JSON.toJSONString(changeFlowCreateReq), uid);
        // 校验变更主体
        checkSubject(changeFlowCreateReq);
        Long parentChangeClassId = changeFlowCreateReq.getParentChangeClassId();
        Long sonChangeClassId = changeFlowCreateReq.getSonChangeClassId();
        String changeItems = changeFlowCreateReq.getChangeItems();
        List<Long> itemIds = null;
        if (StringUtils.isNotBlank(changeItems)) {
            List<ItemVO> itemVOS = JSON.parseArray(changeItems, ItemVO.class);
            itemIds = itemVOS.stream().map(ItemVO::getItemId).collect(Collectors.toList());
        }
        // 工单负责人
        String changeCommander;
        // 获取工单负责人
        GoodsResponseRpc goodsResponseRpc = null;
        try {
            goodsResponseRpc = interiorChangeConfigService.queryCommanderInfo(
                ChangeCommanderPO.builder().parentChangeClassId(parentChangeClassId).sonChangeClassId(sonChangeClassId)
                    .changeSupplierId(changeFlowCreateReq.getChangeSupplier()).goodsInfos(itemIds).build());
            changeCommander = goodsResponseRpc.getEmail();
        } catch (Exception e) {
            log.error("[op:queryCommanderInfo] error, e:{}", e);
            changeCommander = appConfig.getTestEmail();
        }
        // Assert.notNull(goodsResponseRpc, "未查询到负责人信息");
        // 检验是否需要资料
        ChangeConfig changeConfig = changeConfigService.getSonChange(sonChangeClassId);
        Assert.notNull(changeConfig, "二级变更类型不存在");
        Integer needFile = changeConfig.getNeedFile();
        if (NeedFileEnum.NEED.getStatus().equals(needFile)) {
            Assert.notEmpty(changeFlowCreateReq.getUploadFiles(), "必须上传资料");
        }
        // 变更行动项不可为空，最多20项
        List<ChangeExecConfigReq> changeExecProject = changeFlowCreateReq.getChangeExecProject();
        Assert.isTrue(changeExecProject.size() <= appConfig.getChangeExecLimit(),
            "变更行动方案配置数超限");
        // 结束时间不可晚于第二天定时任务执行时间
        Long tomorrowSpecificTime = DateUtils.getTomorrowSpecificTime("09:00:00");
        Assert.isTrue(changeFlowCreateReq.getChangeConfirmResultTime() >= tomorrowSpecificTime, "时间不可晚于下次执行时间");
        Map<String, Object> content = new HashMap<>(10);
        content.put("createUserName", uid);
        content.put("createUser", uid);
        content.put("createTime", System.currentTimeMillis());
        content.put("updateTime", System.currentTimeMillis());
        content.put(CommonConstants.FLOW_OPERATION_KEY, FlowOperationTypeEnum.PASS.getValue());
        // 组装工单创建数据
        FlowCreateReqDTO flowCreateReqDTO = buildFlowCreateReqDTO(ChangeFlowEnum.CHANGE_FLOW_START.getTopoId(), uid,
            JSON.toJSONString(content), FlowxOperationEnum.CREATE.getName());
        // 创建工单
        String flowId = flowService.createFlow(flowCreateReqDTO);
        // 查询工单详情
        FlowDataDTO flowDataDTO = flowService.flowDetail(flowId);
        String nodeId = flowDataDTO.getFlowMeta().getCurrNodeDataList().get(0).getNodeId();
        // 保存工单数据
        ChangeRecord changeRecord = buildChangeRecord(flowId, nodeId, changeFlowCreateReq, changeCommander, uid);
        changeFlowService.saveRecord(changeRecord);
        // 保存变更行动方案记录
        List<ChangeExecRecord> changeExecRecords = buildChangeExecRecord(changeRecord.getId(), changeExecProject);
        changeExecRecords.forEach(exec->changeFlowExecService.saveRecord(exec));
        List<ChangeFile> allFiles = new ArrayList<>();
        // 变更前后图片/视频，非必填
        List<ChangeFlowFile> changeFiles = changeFlowCreateReq.getChangeFiles();
        if (CollectionUtils.isNotEmpty(changeFiles)) {
            allFiles.addAll(buildChangeFileRecord(changeRecord.getId(), changeFiles, FileTypeEnum.CHANGE.getType()));
        }
        // 保存附件，根据配置看是否必传
        List<ChangeFlowFile> uploadFiles = changeFlowCreateReq.getUploadFiles();
        if (CollectionUtils.isNotEmpty(uploadFiles)) {
            allFiles.addAll(buildChangeFileRecord(changeRecord.getId(), uploadFiles, FileTypeEnum.UPLOAD.getType()));
        }
        if (CollectionUtils.isNotEmpty(allFiles)) {
            allFiles.forEach(file->changeFileService.saveRecord(file));
        }
        // 创建代办
        TaskCreateDTO todoTask = todoService.createTodoTask(changeRecord);
        changeRecord.setTodoId(todoTask.getId());
        changeFlowService.updateRecord(changeRecord);
        // 如果发起人=变更负责人，直接提交到执行节点，发送邮件
        if (changeCommander.equals(uid)) {
            log.debug("[createAndSubmit] changeCommander:{}, uid:{}", changeCommander, uid);
            String nextNodeId = flowService.submitFlow(flowId, flowDataDTO, uid,
                ChangeFlowEnum.CHANGE_FLOW_SUBMIT.getTopoId(), JSON.toJSONString(content), true,
                FlowxOperationEnum.SUBMIT.getName(), "提交工单");
            if (null == nextNodeId) {
                throw ExceptionFactory.createBiz(ResponseCode.SUBMIT_FLOW_ERROR, "首次提交节点失败");
            }
            // 更新节点id
            changeRecord.setFlowNode(ChangeFlowEnum.CHANGE_FLOW_EXE.getNodeId());
            changeRecord.setState(ChangeStatusEnum.IN.getStatus());
            changeRecord.setUpdateTime(DateUtils.getCurrentTime());
            changeFlowService.updateRecord(changeRecord);
            HashMap<String, Object> param = new HashMap<>();
            param.put("changeId", changeRecord.getId());
            param.put("changeSubject", changeRecord.getChangeSubject());
            param.put("changeContent", changeRecord.getChangeContent());
            param.put("changeReason", changeRecord.getChangeReason());
            param.put("changeCommander", changeRecord.getChangeCommander());
            param.put("changeCommanderEmail", changeRecord.getChangeCommander());
            param.put("flowUrl", changeRecord.getFlowId());
            param.put("dataList", changeExecRecords);
            ChangeConfigPo changeConfigPo = changeConfigService.queryInfoPo(parentChangeClassId, sonChangeClassId);
            StringBuilder changeType = new StringBuilder("");
            try {
                changeType.append(changeConfigPo.getChangeTypes().get(0).getTypeName());
            } catch (Exception e) {
                log.error("queryInfoPo error:{}", JSON.toJSONString(changeConfigPo));
            }
            try {
                changeType.append(changeConfigPo.getChangeTypes().get(1).getTypeName());
            } catch (Exception e) {
                log.error("queryInfoPo error:{}", JSON.toJSONString(changeConfigPo));
            }
            String subjectParam = changeRecord.getChangeSubject() + changeType.toString()
                + changeRecord.getId().toString();
            qcSendEmail(changeCommander, subjectParam, EmailTemplateEnum.YX_QC_CHANGE_EXECUTE, param);
            // 如果是供应商，再次发送供应商邮件
            if (changeFlowCreateReq.getCreateSource().equals(CreateSourceEnum.TONG_ZHOU.getType())) {
                sendSupplierEmail.sendSupplierEmail(changeRecord.getChangeSupplier(), subjectParam,
                    EmailTemplateEnum.YX_QC_CHANGE_EXECUTE, param);
            }
            return flowId;
        }
        // 如果发起人≠变更负责人，停留在变更申请提交节点，发送邮件
        HashMap<String, Object> param = new HashMap<>();
        param.put("changeId", changeRecord.getId());
        param.put("changeSubject", changeRecord.getChangeSubject());
        ChangeConfigPo changeConfigPo = changeConfigService.queryInfoPo(parentChangeClassId, sonChangeClassId);
        StringBuilder changeType = new StringBuilder("");
        try {
            changeType.append(changeConfigPo.getChangeTypes().get(0).getTypeName());
        } catch (Exception e) {
            log.error("queryInfoPo error:{}", JSON.toJSONString(changeConfigPo));
        }
        try {
            changeType.append(changeConfigPo.getChangeTypes().get(1).getTypeName());
        } catch (Exception e) {
            log.error("queryInfoPo error:{}", JSON.toJSONString(changeConfigPo));
        }
        param.put("changeType", changeType.toString());
        param.put("flowUrl", changeRecord.getFlowId());
        String subjectParam = changeRecord.getId().toString();
        qcSendEmail(changeCommander, subjectParam, EmailTemplateEnum.YX_QC_CHANGE_RELEASE_FLOW, param);
        // 如果是供应商，再次发送供应商邮件
        if (changeFlowCreateReq.getCreateSource().equals(CreateSourceEnum.TONG_ZHOU.getType())) {
            sendSupplierEmail.sendSupplierEmail(changeRecord.getChangeSupplier(), subjectParam,
                EmailTemplateEnum.YX_QC_CHANGE_RELEASE_FLOW, param);
        }
        return flowId;
    }

    /**
     * 严选QC端发送邮件
     * @param changeCommander   负责人
     * @param subjectParam      主体参数
     * @param emailTemplateEnum 邮件模板
     * @param param             正文参数
     */
    public void qcSendEmail(String changeCommander, String subjectParam, EmailTemplateEnum emailTemplateEnum,
        Map<String, Object> param) {
        try {
            IusDepartmentReq iusDepartmentReq = new IusDepartmentReq();
            iusDepartmentReq.setHasOrgPos(true);
            iusDepartmentReq.setIcac(true);
            iusDepartmentReq.setUids(Collections.singletonList(changeCommander));
            HashMap<String, List<SecondaryDepartments>> map = iusService.queryDepartment(iusDepartmentReq);
            log.info("[qcSendEmail] subjectParam:{}, map:{}", subjectParam, map);
            List<SecondaryDepartments> secondaryDepartments = map.get(changeCommander);
            List<String> ccList = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(secondaryDepartments)) {
                ccList = secondaryDepartments.stream().map(SecondaryDepartments::getUid).collect(Collectors.toList());
            }
            // 变更管理QM，所有邮件都要发
            ccList.add(appConfig.getChangeManageQM());
            iEmailService.sendEmail(Collections.singletonList(changeCommander), ccList, param, emailTemplateEnum,
                subjectParam);
        } catch (Exception e) {
            log.error("[op:qcSendEmail] error,changeCommander:{}, subjectParam:{}, e:{}", changeCommander, subjectParam,
                e);
        }
    }

    private List<ChangeFile> buildChangeFileRecord(Long changeRecordId, List<ChangeFlowFile> files, Integer type) {
        return files.stream().map(f -> {
            ChangeFile changeFile = new ChangeFile();
            changeFile.setChangeRecordId(changeRecordId);
            changeFile.setFileType(type);
            changeFile.setFileName(f.getFileName());
            changeFile.setFileUrl(f.getFileUrl());
            changeFile.setCreateTime(DateUtils.getCurrentTime());
            changeFile.setUpdateTime(DateUtils.getCurrentTime());
            return changeFile;
        }).collect(Collectors.toList());
    }

    private List<ChangeExecRecord> buildChangeExecRecord(Long changeRecordId,
        List<ChangeExecConfigReq> changeExecProject) {
        return changeExecProject.stream().map(c -> {
            ChangeExecRecord changeExecRecord = new ChangeExecRecord();
            changeExecRecord.setChangeRecordId(changeRecordId);
            changeExecRecord.setChangeExecDepartment(c.getChangeExecDepartment());
            changeExecRecord.setChangeExecUserType(c.getChangeExecUserType());
            changeExecRecord.setChangeExecUser(c.getChangeExecUser());
            changeExecRecord.setChangeExecUserEmail(c.getChangeExecUserEmail());
            changeExecRecord.setChangeRiskDesc(c.getChangeRiskDesc());
            changeExecRecord.setChangeExecProject(c.getChangeExecProject());
            changeExecRecord.setChangeChecking(c.getChangeChecking());
            changeExecRecord.setChangeExecFinishTime(c.getChangeExecFinishTime());
            changeExecRecord.setChangeExecFinishDesc(c.getChangeExecFinishDesc());
            changeExecRecord.setCreateTime(DateUtils.getCurrentTime());
            changeExecRecord.setUpdateTime(DateUtils.getCurrentTime());
            return changeExecRecord;
        }).collect(Collectors.toList());
    }

    private void checkSubject(ChangeFlowCreateReq changeFlowCreateReq) {
        ChangeSubjectEnum type = ChangeSubjectEnum.getByType(changeFlowCreateReq.getChangeSubject());
        Assert.notNull(type, "变更主体不存在");
        switch (type) {
            case PRODUCT:
                Assert.isTrue(StringUtils.isNotBlank(changeFlowCreateReq.getChangeItems()), " 变更商品不可为空");
                break;
            case SUPPLIER:
                Assert.isTrue(StringUtils.isNotBlank(changeFlowCreateReq.getChangeSupplier()), " 变更供应商不可为空");
                break;
            case OTHER:
                break;
            default:
                throw ExceptionFactory.createBiz(ResponseCode.CHANGE_SUBJECT_ERROR, "变更主体类型错误");
        }
    }

    private FlowCreateReqDTO buildFlowCreateReqDTO(String topoId, String uid, String content, String operateResult) {
        FlowCreateReqDTO flowCreateReqDTO = new FlowCreateReqDTO();
        flowCreateReqDTO.setTopoId(topoId);
        flowCreateReqDTO.setUid(uid);
        flowCreateReqDTO.setUserName(uid);
        flowCreateReqDTO.setOperateResult(operateResult);
        flowCreateReqDTO.setWorkOrderId(StringUtils.joinWith("-", topoId, UUID.randomUUID().toString()));
        flowCreateReqDTO.setContent(content);
        return flowCreateReqDTO;
    }

    private ChangeRecord buildChangeRecord(String flowId, String nodeId, ChangeFlowCreateReq changeFlowCreateReq,
                                           String changeCommander, String uid) {
        ChangeRecord changeRecord = new ChangeRecord();
        changeRecord.setFlowId(Long.parseLong(flowId));
        changeRecord.setFlowNode(nodeId);
        changeRecord.setChangeSubject(changeFlowCreateReq.getChangeSubject());
        changeRecord.setParentChangeClassId(changeFlowCreateReq.getParentChangeClassId());
        changeRecord.setSonChangeClassId(changeFlowCreateReq.getSonChangeClassId());
        changeRecord.setChangeLevel(changeFlowCreateReq.getChangeLevel());
        changeRecord.setChangeCommander(changeCommander);
        changeRecord.setChangeDepartment(changeFlowCreateReq.getChangeDepartment());
        List<ChangeExecConfigReq> changeExecProject = changeFlowCreateReq.getChangeExecProject();
        List<String> execDepartmentList = changeExecProject.stream().map(ChangeExecConfigReq::getChangeExecDepartment)
            .collect(Collectors.toList());
        changeRecord.setParticipateChangeExecDepartment(JSON.toJSONString(execDepartmentList));
        if (ChangeSubjectEnum.PRODUCT.getType().equals(changeFlowCreateReq.getChangeSubject())) {
            // 当变更类型是商品时有值
            changeRecord.setChangeItem(changeFlowCreateReq.getChangeItems());
        }
        if (ChangeSubjectEnum.SUPPLIER.getType().equals(changeFlowCreateReq.getChangeSubject())) {
            changeRecord.setChangeSupplier(changeFlowCreateReq.getChangeSupplier());
        }
        changeRecord.setChangeReason(changeFlowCreateReq.getChangeReason());
        changeRecord.setChangeContent(changeFlowCreateReq.getChangeContent());
        changeRecord.setChangeRiskDesc(changeFlowCreateReq.getChangeRiskDesc());
        changeRecord.setChangeProfit(changeFlowCreateReq.getChangeProfit());
        changeRecord.setChangeProfitDesc(changeFlowCreateReq.getChangeProfitDesc());
        changeRecord.setChangeConfirmResultTime(changeFlowCreateReq.getChangeConfirmResultTime());
        changeRecord.setState(ChangeStatusEnum.WAIT.getStatus());
        // 变更结论
        changeRecord.setCreateSource(changeFlowCreateReq.getCreateSource());
        changeRecord.setCreateSupplier(changeFlowCreateReq.getChangeSupplier());
        changeRecord.setCreateTime(DateUtils.getCurrentTime());
        changeRecord.setUpdateTime(DateUtils.getCurrentTime());
        changeRecord.setCreator(uid);
        return changeRecord;
    }

    public String submit(ChangeFlowSubmitReq changeFlowSubmitReq) {
        log.info("[submitFlow] changeFlowReq:{}", JSON.toJSONString(changeFlowSubmitReq));
        Long flowId = changeFlowSubmitReq.getFlowId();
        // 查询工单有效性
        ChangeRecord changeRecord = this.getFlowInfo(flowId);
        // 检查工单节点
        this.checkNode(changeRecord.getFlowNode(), Collections.singletonList(changeFlowSubmitReq.getCurrentNodeId()));
        String uid = RequestLocalBean.getUid();
        String changeCommander = changeRecord.getChangeCommander();
        if (!uid.equals(changeCommander)) {
            throw ExceptionFactory.createBiz(ResponseCode.NO_AUTH, ResponseCode.NO_AUTH.getMsg());
        }
        // 获取工单详情
        FlowDataDTO flowDataDTO = flowService.flowDetail(flowId.toString());
        if (flowDataDTO == null) {
            throw ExceptionFactory.createBiz(ResponseCode.DETAIL_FLOW_ERROR, "工单查询错误，不存在");
        }

        return checkUpdateAndSubmit(flowId, flowDataDTO, uid, changeRecord, changeRecord.getFlowNode(), changeFlowSubmitReq);
    }

    private String checkUpdateAndSubmit(Long flowId, FlowDataDTO flowDataDTO, String uid, ChangeRecord changeRecord,
        String currentNode, ChangeFlowSubmitReq changeFlowSubmitReq) {
        ChangeFlowEnum node = ChangeFlowEnum.getByNodeId(currentNode);
        Assert.notNull(node, "节点配置不存在");
        log.debug("[checkUpdateAndSubmit] flowId:{}, nodeEnum:{}, changeFlowSubmitReq:{}", flowId, node,
            JSON.toJSONString(changeFlowSubmitReq));
        // 工单流传
        Map<String, Object> content = new HashMap<>(CommonConstants.INIT_HASH_MAP_SIZE);
        content.put("updateTime", System.currentTimeMillis());
        content.put(CommonConstants.FLOW_OPERATION_KEY, FlowOperationTypeEnum.PASS.getValue());
        switch (node) {
            // 变更申请提交节点，可以修改数据，以新的数据为准
            case CHANGE_FLOW_SUBMIT:
                // 检验是否需要资料
                ChangeConfig changeConfig = changeConfigService.getSonChange(changeFlowSubmitReq.getSonChangeClassId());
                Assert.notNull(changeConfig, "二级变更类型不存在");
                Integer needFile = changeConfig.getNeedFile();
                if (NeedFileEnum.NEED.getStatus().equals(needFile)) {
                    Assert.notEmpty(changeFlowSubmitReq.getFiles(), "必须上传资料");
                }
                // 变更行动项不可为空，最多20项
                List<ChangeExecConfigReq> changeExecProjectList = changeFlowSubmitReq.getChangeExecProjectList();
                Assert.isTrue(changeExecProjectList.size() <= appConfig.getChangeExecLimit(),
                        "变更行动方案配置数超限");
                changeRecord.setParentChangeClassId(changeFlowSubmitReq.getParentChangeClassId());
                changeRecord.setSonChangeClassId(changeFlowSubmitReq.getSonChangeClassId());
                List<String> execDepartmentList = changeExecProjectList.stream().map(ChangeExecConfigReq::getChangeExecDepartment)
                        .collect(Collectors.toList());
                changeRecord.setParticipateChangeExecDepartment(JSON.toJSONString(execDepartmentList));
                changeRecord.setChangeItem(changeFlowSubmitReq.getChangeItems());
                changeRecord.setChangeSupplier(changeFlowSubmitReq.getChangeSupplier());
                changeRecord.setChangeReason(changeFlowSubmitReq.getChangeReason());
                changeRecord.setChangeContent(changeFlowSubmitReq.getChangeContent());
                changeRecord.setChangeRiskDesc(changeFlowSubmitReq.getChangeRiskDesc());
                changeRecord.setChangeChecking(changeFlowSubmitReq.getChangeChecking());
                changeRecord.setChangeProfit(changeFlowSubmitReq.getChangeProfit());
                changeRecord.setChangeProfitDesc(changeFlowSubmitReq.getChangeProfitDesc());
                changeRecord.setChangeConfirmResultTime(changeFlowSubmitReq.getChangeConfirmResultTime());
                changeRecord.setUpdateTime(DateUtils.getCurrentTime());
                // 提交工单
                String submitNode = flowService.submitFlow(flowId.toString(), flowDataDTO, uid,
                    ChangeFlowEnum.CHANGE_FLOW_SUBMIT.getTopoId(), JSON.toJSONString(content), true,
                    FlowxOperationEnum.SUBMIT.getName(), "提交工单");
                // 更新工单数据
                changeRecord.setFlowNode(submitNode);
                changeRecord.setState(ChangeStatusEnum.IN.getStatus());
                changeRecord.setUpdateTime(DateUtils.getCurrentTime());
                changeFlowService.updateRecord(changeRecord);
                // 更新行动执行方案，覆盖操作，先删除，后插入
                Integer changeExecCount = changeFlowExecService.deleteByChangeRecordId(changeRecord.getId());
                log.info("[CHANGE_FLOW_SUBMIT] delete changeExecCount:{}", changeExecCount);
                // 保存变更行动方案记录
                List<ChangeExecRecord> changeExecRecords = buildChangeExecRecord(changeRecord.getId(),
                    changeFlowSubmitReq.getChangeExecProjectList());
                changeExecRecords.forEach(exec->changeFlowExecService.saveRecord(exec));
                // 更新附件，覆盖操作，先删除，后插入
                List<ChangeFlowFile> files = changeFlowSubmitReq.getFiles();
                if (CollectionUtils.isNotEmpty(files)) {
                    changeFileService.deleteByChangeRecordId(changeRecord.getId());
                    List<ChangeFile> changeFiles = buildChangeFileRecord(changeRecord.getId(), files, FileTypeEnum.CHANGE.getType());
                    changeFiles.forEach(file -> changeFileService.saveRecord(file));
                }
                HashMap<String, Object> param = new HashMap<>();
                param.put("changeId", changeRecord.getId());
                param.put("changeSubject", changeRecord.getChangeSubject());
                param.put("changeContent", changeRecord.getChangeContent());
                param.put("changeReason", changeRecord.getChangeReason());
                param.put("changeCommander", changeRecord.getChangeCommander());
                param.put("changeCommanderEmail", changeRecord.getChangeCommander());
                param.put("flowUrl", changeRecord.getFlowId());
                param.put("dataList", changeExecRecords);
                String subjectParam = changeRecord.getId().toString();
                qcSendEmail(changeRecord.getChangeCommander(), subjectParam,
                    EmailTemplateEnum.YX_QC_CHANGE_EXECUTE, param);
                // 如果是供应商，再次发送供应商邮件
                if (changeRecord.getCreateSource().equals(CreateSourceEnum.TONG_ZHOU.getType())) {
                    sendSupplierEmail.sendSupplierEmail(changeRecord.getChangeSupplier(), subjectParam,
                        EmailTemplateEnum.YX_QC_CHANGE_EXECUTE, param);
                }
                return submitNode;
            case CHANGE_FLOW_CONFIRM:
                Integer changeResult = changeFlowSubmitReq.getChangeResult();
                ChangeResultEnum changeResultStatus = ChangeResultEnum.getByStatus(changeResult);
                Assert.notNull(changeResultStatus, "变更结论类型错误");
                // 填写变更结论
                changeRecord.setChangeResult(changeResultStatus.getStatus());
                // 填写备注
                changeRecord.setRemark(changeFlowSubmitReq.getRemark());
                switch (changeResultStatus) {
                    case FINISH_ALL:
                    case FINISH_PART:
                        List<ChangeExecConfigReq> execProjectList = changeFlowSubmitReq.getChangeExecProjectList();
                        List<ChangeExecRecord> changeExecRecordList = execProjectList.stream().map(exec -> {
                            Long changeExecFinishTime = exec.getChangeExecFinishTime();
                            Assert.notNull(changeExecFinishTime, "行动完成时间不可为空" + exec.getChangeTemplateId());
                            ChangeExecRecord changeExecRecord = new ChangeExecRecord();
                            changeExecRecord.setId(exec.getChangeExecId());
                            changeExecRecord.setChangeExecFinishTime(exec.getChangeExecFinishTime());
                            changeExecRecord.setChangeExecFinishDesc(exec.getChangeExecFinishDesc());
                            return changeExecRecord;
                        }).collect(Collectors.toList());
                        // 完成直接完结
                        String confirmNode = flowService.submitFlow(flowId.toString(), flowDataDTO, uid,
                            ChangeFlowEnum.CHANGE_FLOW_CONFIRM.getTopoId(), JSON.toJSONString(content), true,
                            FlowxOperationEnum.SUBMIT.getName(), "提交工单");
                        changeRecord.setState(ChangeStatusEnum.END.getStatus());
                        changeRecord.setFlowNode(confirmNode);
                        changeRecord.setUpdateTime(DateUtils.getCurrentTime());
                        changeFlowService.updateRecord(changeRecord);
                        changeExecRecordList.forEach(exec->changeFlowExecService.update(exec));
                        todoService.progressTodoTask(changeRecord, OperateTypeEnum.FINISH.getType());
                        // 发送邮件
                        HashMap<String, Object> finishPartMap = new HashMap<>();
                        finishPartMap.put("changeId", changeRecord.getId());
                        finishPartMap.put("changeSubject", changeRecord.getChangeSubject());
                        finishPartMap.put("flowUrl", changeRecord.getFlowId());
                        ChangeConfigPo changeConfigPo = changeConfigService
                            .queryInfoPo(changeRecord.getParentChangeClassId(), changeRecord.getSonChangeClassId());
                        StringBuilder changeType = new StringBuilder("");
                        try {
                            changeType.append(changeConfigPo.getChangeTypes().get(0).getTypeName());
                        } catch (Exception e) {
                            log.error("queryInfoPo error:{}", JSON.toJSONString(changeConfigPo));
                        }
                        try {
                            changeType.append(changeConfigPo.getChangeTypes().get(1).getTypeName());
                        } catch (Exception e) {
                            log.error("queryInfoPo error:{}", JSON.toJSONString(changeConfigPo));
                        }
                        //【已完结】变更主体+变更内容+工单ID 变更风险行动项已完结，请开始执行变更。
                        String finishSubjectParam = changeRecord.getChangeSubject() + changeRecord.getChangeContent()
                            + changeRecord.getId();
                        qcSendEmail(changeRecord.getChangeCommander(), finishSubjectParam,
                            EmailTemplateEnum.YX_QC_CHANGE_FINISH, finishPartMap);
                        // 如果是供应商，再次发送供应商邮件
                        if (changeRecord.getCreateSource().equals(CreateSourceEnum.TONG_ZHOU.getType())) {
                            sendSupplierEmail.sendSupplierEmail(changeRecord.getChangeSupplier(), finishSubjectParam,
                                EmailTemplateEnum.YX_QC_CHANGE_FINISH, finishPartMap);
                        }
                        return confirmNode;
                    case CANCEL:
                        // 取消填写取消原因
                        String cancelReason = changeFlowSubmitReq.getCancelReason();
                        Assert.isTrue(StringUtils.isNotBlank(cancelReason), "变更取消原因不可为空");
                        changeRecord.setCancelReason(cancelReason);
                        String cancelNode = flowService.submitFlow(flowId.toString(), flowDataDTO, uid,
                            ChangeFlowEnum.CHANGE_FLOW_CONFIRM.getTopoId(), JSON.toJSONString(content), true,
                            FlowxOperationEnum.SUBMIT.getName(), "提交工单");
                        changeRecord.setState(ChangeStatusEnum.CANCEL.getStatus());
                        changeRecord.setFlowNode(cancelNode);
                        changeRecord.setUpdateTime(DateUtils.getCurrentTime());
                        changeFlowService.updateRecord(changeRecord);
                        todoService.progressTodoTask(changeRecord, OperateTypeEnum.FINISH.getType());
                        // 发送邮件
                        Map<String, Object> cancelMap = new HashMap<>();
                        cancelMap.put("changeId", changeRecord.getId());
                        cancelMap.put("changeSubject", changeRecord.getChangeSubject());
                        cancelMap.put("changeContent", changeRecord.getChangeContent());
                        cancelMap.put("changeCommander", changeRecord.getChangeCommander());
                        cancelMap.put("cancelReason", changeRecord.getCancelReason());
                        String cancelSubjectParam = changeRecord.getId().toString();
                        qcSendEmail(changeRecord.getChangeCommander(), cancelSubjectParam,
                            EmailTemplateEnum.YX_QC_CHANGE_SUBMIT_CANCEL, cancelMap);
                        // 如果是供应商，再次发送供应商邮件
                        if (changeRecord.getCreateSource().equals(CreateSourceEnum.TONG_ZHOU.getType())) {
                            sendSupplierEmail.sendSupplierEmail(changeRecord.getChangeSupplier(), cancelSubjectParam,
                                    EmailTemplateEnum.YX_QC_CHANGE_SUBMIT_CANCEL, cancelMap);
                        }
                        return cancelNode;
                    case DELAY:
                        // 延期不流转工单
                        long changeConfirmResultTime = changeFlowSubmitReq.getChangeConfirmResultTime();
                        Long tomorrowSpecificTime = DateUtils.getTomorrowSpecificTime("09:00:00");
                        Assert.isTrue(changeConfirmResultTime >= tomorrowSpecificTime, "时间不可晚于下次执行时间");
                        List<ChangeExecConfigReq> execProjectList1 = changeFlowSubmitReq.getChangeExecProjectList();
                        List<ChangeExecRecord> changeExecRecords1 = execProjectList1.stream().map(exec -> {
                            Long changeExecFinishTime = exec.getChangeExecFinishTime();
                            Assert.notNull(changeExecFinishTime, "行动完成时间不可为空" + exec.getChangeTemplateId());
                            ChangeExecRecord changeExecRecord = new ChangeExecRecord();
                            changeExecRecord.setId(exec.getChangeExecId());
                            changeExecRecord.setChangeExecFinishTime(exec.getChangeExecFinishTime());
                            changeExecRecord.setChangeExecFinishDesc(exec.getChangeExecFinishDesc());
                            return changeExecRecord;
                        }).collect(Collectors.toList());
                        changeRecord.setState(ChangeStatusEnum.DELAY.getStatus());
                        // 更改变更结果确认时间
                        changeRecord.setChangeConfirmResultTime(changeConfirmResultTime);
                        changeRecord.setUpdateTime(DateUtils.getCurrentTime());
                        changeFlowService.updateRecord(changeRecord);
                        changeExecRecords1.forEach(exec->changeFlowExecService.update(exec));
                        // 变更行动项
                        return null;
                    default:
                        return null;
                }
                // 其他几点，不可提交
            case CHANGE_FLOW_EXE:
            case CHANGE_FLOW_START:
            case END:
            default:
                throw ExceptionFactory.createBiz(ResponseCode.NODE_ERROR, "不可提交节点" + currentNode);
        }
    }

    private ChangeRecord getFlowInfo(Long flowId) {
        ChangeRecord changeRecord = changeFlowService.getByFlowId(flowId);
        if (changeRecord == null) {
            throw ExceptionFactory.createBiz(ResponseCode.ERROR_FLOW_ID, "工单id不存在");
        }
        return changeRecord;
    }

    private void checkNode(String recordNode, List<String> checkNode){
        Optional<String> nodeOptional = checkNode.stream().filter(check -> check.equals(recordNode)).findAny();
        if (!nodeOptional.isPresent()) {
            throw ExceptionFactory.createBiz(ResponseCode.NODE_ERROR, "工单已流转至其他节点");
        }
    }

    public Boolean cancel(ChangeFlowCancelReq req) {
        log.info("[cancel] req:{}", JSON.toJSONString(req));
        Long flowId = req.getFlowId();
        // 查询工单有效性
        ChangeRecord changeRecord = getFlowInfo(flowId);
        log.info("[cancel] nodeId:{}", changeRecord.getFlowNode());
        // 检查工单节点
        this.checkNode(changeRecord.getFlowNode(), Collections.singletonList(ChangeFlowEnum.CHANGE_FLOW_SUBMIT.getNodeId()));
        String uid = RequestLocalBean.getUid();
        String changeCommander = changeRecord.getChangeCommander();
        if (!uid.equals(changeCommander)) {
            throw ExceptionFactory.createBiz(ResponseCode.NO_AUTH, ResponseCode.NO_AUTH.getMsg());
        }
        // 获取工单详情
        FlowDataDTO flowDataDTO = flowService.flowDetail(flowId.toString());
        if (flowDataDTO == null) {
            throw ExceptionFactory.createBiz(ResponseCode.DETAIL_FLOW_ERROR, "工单查询错误，不存在");
        }
        // 工单流转
        Map<String, Object> content = new HashMap<>(CommonConstants.INIT_HASH_MAP_SIZE);
        content.put("updateTime", System.currentTimeMillis());
        content.put(CommonConstants.FLOW_OPERATION_KEY, FlowOperationTypeEnum.REFUSE.getValue());
        String nextNodeId = flowService.submitFlow(String.valueOf(flowId), flowDataDTO, uid,
            ChangeFlowEnum.CHANGE_FLOW_SUBMIT.getTopoId(), JSON.toJSONString(content), false,
            FlowxOperationEnum.APPROVE_FAIL.getName(), "取消工单");
        log.info("[cancel] flowId:{}, nextNodeId:{}", flowId, nextNodeId);
        // 填充更新数据
        changeRecord.setFlowNode(nextNodeId);
        changeRecord.setState(ChangeStatusEnum.CANCEL.getStatus());
        changeRecord.setCancelReason(req.getCancelReason());
        changeRecord.setUpdateTime(DateUtils.getCurrentTime());
        todoService.progressTodoTask(changeRecord, OperateTypeEnum.FINISH.getType());
        Map<String, Object> cancelMap = new HashMap<>();
        cancelMap.put("changeId", changeRecord.getId());
        cancelMap.put("changeSubject", changeRecord.getChangeSubject());
        cancelMap.put("changeContent", changeRecord.getChangeContent());
        cancelMap.put("changeCommander", changeRecord.getChangeCommander());
        cancelMap.put("cancelReason", changeRecord.getCancelReason());
        String cancelSubjectParam = changeRecord.getId().toString();
        qcSendEmail(changeCommander, cancelSubjectParam, EmailTemplateEnum.YX_QC_CHANGE_SUBMIT_CANCEL, cancelMap);
        // 如果是供应商，再次发送供应商邮件
        if (changeRecord.getCreateSource().equals(CreateSourceEnum.TONG_ZHOU.getType())) {
            sendSupplierEmail.sendSupplierEmail(changeRecord.getChangeSupplier(), cancelSubjectParam,
                EmailTemplateEnum.YX_QC_CHANGE_SUBMIT_CANCEL, cancelMap);
        }
        return changeFlowService.updateRecord(changeRecord);
    }

    public BasicChangeFlowVO quote(Long flowId) {
        // 获取工单详情
        ChangeRecord changeRecord = this.getFlowInfo(flowId);
        // 获取附件
        List<ChangeFlowFile> changeFileList = changeFileService.getChangeFileList(changeRecord.getId());
        return BasicChangeFlowVO.builder().parentChangeClassId(changeRecord.getParentChangeClassId())
            .sonChangeClassId(changeRecord.getSonChangeClassId()).changeSubject(changeRecord.getChangeSubject())
            .changeItem(changeRecord.getChangeItem()).changeSupplier(changeRecord.getChangeSupplier())
            .changeReason(changeRecord.getChangeReason()).changeContent(changeRecord.getChangeContent())
            .changeRiskDesc(changeRecord.getChangeRiskDesc()).changeProfit(changeRecord.getChangeProfit())
            .changeProfitDesc(changeRecord.getChangeProfitDesc()).files(changeFileList).build();
    }

    public ChangeFlowVO detail(Long flowId) {
        ChangeRecord changeRecord = changeFlowService.getByFlowId(flowId);
        if (changeRecord == null) {
            throw ExceptionFactory.createBiz(ResponseCode.ERROR_FLOW_ID, "工单id不存在");
        }
        log.debug("[detail] detail:{}", JSON.toJSONString(changeRecord));
        ChangeFlowVO changeFlowVO = new ChangeFlowVO();
        changeFlowVO.setId(changeRecord.getId());
        changeFlowVO.setFlowId(changeRecord.getFlowId());
        changeFlowVO.setParentChangeClassId(changeRecord.getParentChangeClassId());
        changeFlowVO.setSonChangeClassId(changeRecord.getSonChangeClassId());
        changeFlowVO.setChangeSubject(changeRecord.getChangeSubject());
        ChangeType parentChangeType = changeTypeService.getChangeTypeById(changeRecord.getParentChangeClassId());
        if (parentChangeType == null) {
            throw ExceptionFactory.createBiz(ResponseCode.CHANGE_TYPE_NOT_EXIST, "变更类型不存在");
        }
        ChangeType sonChangeType = changeTypeService.getChangeTypeById(changeRecord.getSonChangeClassId());
        if (sonChangeType == null) {
            throw ExceptionFactory.createBiz(ResponseCode.CHANGE_TYPE_NOT_EXIST, "变更类型配置不存在");
        }
        changeFlowVO.setChangeType(parentChangeType.getTypeName() + ">" + sonChangeType.getTypeName());
        changeFlowVO.setChangeLevel(changeRecord.getChangeLevel());
        changeFlowVO.setChangeDepartment(changeRecord.getChangeDepartment());
        changeFlowVO.setChangeCommander(changeRecord.getChangeCommander());
        changeFlowVO.setChangeSupplier(changeRecord.getChangeSupplier());
        changeFlowVO.setChangeReason(changeRecord.getChangeReason());
        changeFlowVO.setChangeContent(changeRecord.getChangeContent());
        changeFlowVO.setChangeRiskDesc(changeRecord.getChangeRiskDesc());
        // 获取附件
        List<ChangeFlowFile> changeFileList = changeFileService.getChangeFileList(changeRecord.getId());
        changeFlowVO.setFiles(changeFileList);
        changeFlowVO.setChangeProfit(changeRecord.getChangeProfit());
        changeFlowVO.setChangeProfitDesc(changeRecord.getChangeProfitDesc());
        String itemJsonStr = changeRecord.getChangeItem();
        if (StringUtils.isNotBlank(itemJsonStr)) {
            List<ItemVO> itemList = JSON.parseArray(itemJsonStr, ItemVO.class);
            changeFlowVO.setChangeItems(itemList);
            // 变更结果确认节点，展示变更商品基础信息
            String flowNode = changeRecord.getFlowNode();
            if (ChangeFlowEnum.CHANGE_FLOW_CONFIRM.getNodeId().equals(flowNode)) {
                List<Long> itemIds = itemList.stream().map(ItemVO::getItemId).collect(Collectors.toList());
                // 批量查询spu信息
                List<SpuTO> spuTOS = itemService.batchQuerySpuInfo(BatchQuerySpuInfoParam.builder().ids(itemIds)
                        .commonProps(new ArrayList<>()).spuProps(Arrays.asList("itemSetupType","+")).build());
                log.debug("[detail] spuTOS:{}", JSON.toJSONString(spuTOS));
                // 批量查询物理类目
                Map<Long, List<SimplePhyCateGoryResultCo>> categoryChain = itemService
                        .queryBySpuIds(CommonIdsParamQuery.builder().ids(itemIds).build());
                // 查询商品对应负责人信息
                Map<Long, ChangeGoodsPrincipalPO> longChangeGoodsPrincipalPOMap = interiorChangeConfigService
                    .queryGoodsPrincipalInfo(itemIds);
                List<ItemBasicInfoVO> itemBasicInfoVOS = itemList.stream().map(itemVO -> {
                    ItemBasicInfoVO itemBasicInfoVO = new ItemBasicInfoVO();
                    Long itemId = itemVO.getItemId();
                    itemBasicInfoVO.setItemId(itemId);
                    itemBasicInfoVO.setItemName(itemVO.getItemName());
                    itemBasicInfoVO.setQcCategory(null);
                    List<SimplePhyCateGoryResultCo> simplePhyCateGoryResultCos = categoryChain.get(itemId);
                    if (CollectionUtils.isEmpty(simplePhyCateGoryResultCos)) {
                        throw ExceptionFactory.createBiz(ResponseCode.THIRD_ERR, "未查询到物理类目");
                    }
                    List<CategoryInfoVO> categoryInfoVOS = simplePhyCateGoryResultCos.stream().map(phy -> {
                        CategoryInfoVO categoryInfoVO = new CategoryInfoVO();
                        categoryInfoVO.setId(phy.getId());
                        categoryInfoVO.setName(phy.getName());
                        return categoryInfoVO;
                    }).collect(Collectors.toList());
                    itemBasicInfoVO.setPhyCategory(categoryInfoVOS);
                    Optional<SpuTO> optionalSpuTO = spuTOS.stream().filter(spu -> spu.getId() == itemId).findAny();
                    if (!optionalSpuTO.isPresent()) {
                        throw ExceptionFactory.createBiz(ResponseCode.THIRD_ERR, "未查询到商品详情");
                    }
                    SpuTO spuTO = optionalSpuTO.get();
                    Map<String, String> propertyMap = spuTO.getPropertyMap();
                    itemBasicInfoVO.setItemSetupType(Integer.valueOf(propertyMap.get("itemSetupType")));
                    String businessForm = propertyMap.get("businessForm");
                    int business = StringUtils.isBlank(businessForm) ? 0 : Integer.parseInt(businessForm);
                    itemBasicInfoVO.setBusinessForm(business);
                    itemBasicInfoVO.setStatus(spuTO.getStatus());
                    ChangeGoodsPrincipalPO changeGoodsPrincipalPO = longChangeGoodsPrincipalPOMap.get(itemId);
                    itemBasicInfoVO.setChangeGoodsPrincipal(changeGoodsPrincipalPO);
                    return itemBasicInfoVO;
                }).collect(Collectors.toList());
                changeFlowVO.setItemBasicInfoList(itemBasicInfoVOS);
            }
        } else {
            changeFlowVO.setItemBasicInfoList(null);
        }
        changeFlowVO.setChangeState(changeRecord.getState());
        changeFlowVO.setChangeCreator(changeRecord.getCreator());
        List<ChangeFlowExecVO> changeFlowExecRecord = changeFlowExecService.getChangeFlowExecRecord(changeRecord.getId());
        changeFlowVO.setChangeExecProjectList(changeFlowExecRecord);
        changeFlowVO.setCreateTime(changeRecord.getCreateTime());
        changeFlowVO.setChangeConfirmResultTime(changeRecord.getChangeConfirmResultTime());
        changeFlowVO.setChangeResult(changeRecord.getChangeResult());
        changeFlowVO.setChangeResultDesc(changeRecord.getChangeResultDesc());
        changeFlowVO.setTopoId(ChangeFlowEnum.CHANGE_FLOW.getTopoId());
        return changeFlowVO;
    }

    public ChangeFlowListVO query(Integer page, Integer pageSize, ChangeFlowListQueryReq changeFlowListQueryReq) {
        log.info("[query] page:{}, pageSize:{}, changeFlowListQueryReq:{}", page, pageSize,
            JSON.toJSONString(changeFlowListQueryReq));
        //进行分页
        PageHelper.startPage(page, pageSize);
        PageInfo<ChangeRecord> changeRecordPageInfo = new PageInfo<>(
            changeRecordMapper.selectByCondition(changeFlowListQueryReq));
        List<ChangeRecord> changeRecords = changeRecordPageInfo.getList();
        List<ChangeFlowVO> list = new ArrayList<>();
        // 处理数据
        if (CollectionUtils.isNotEmpty(changeRecords)) {
            list = changeRecords.stream().map(c -> {
                ChangeFlowVO changeFlowVO = new ChangeFlowVO();
                changeFlowVO.setId(c.getId());
                changeFlowVO.setFlowId(c.getFlowId());
                changeFlowVO.setChangeSubject(c.getChangeSubject());
                ChangeType parentChangeType = changeTypeService.getChangeTypeById(c.getParentChangeClassId());
                ChangeType sonChangeType = changeTypeService.getChangeTypeById(c.getSonChangeClassId());
                changeFlowVO.setChangeType(parentChangeType.getTypeName() + ">" + sonChangeType.getTypeName());
                changeFlowVO.setChangeDepartment(c.getChangeDepartment());
                changeFlowVO.setChangeContent(c.getChangeContent());
                changeFlowVO.setChangeCommander(c.getChangeCommander());
                String itemJsonStr = c.getChangeItem();
                if (StringUtils.isNotBlank(itemJsonStr)) {
                    changeFlowVO.setChangeItems(JSON.parseArray(itemJsonStr, ItemVO.class));
                }
                changeFlowVO.setChangeSupplier(c.getChangeSupplier());
                changeFlowVO.setChangeState(c.getState());
                changeFlowVO.setChangeCreator(c.getCreator());
                String participateChangeExecDepartment = c.getParticipateChangeExecDepartment();
                if (StringUtils.isNotBlank(participateChangeExecDepartment)) {
                    changeFlowVO.setExecDepartmentStrList(JSON.parseArray(participateChangeExecDepartment, String.class));
                }
                changeFlowVO.setCreateTime(c.getCreateTime());
                changeFlowVO.setChangeConfirmResultTime(c.getChangeConfirmResultTime());
                changeFlowVO.setCancelReason(c.getCancelReason());
                changeFlowVO.setRemark(c.getRemark());
                return changeFlowVO;
            }).collect(Collectors.toList());
        }
        PageVO pageVO = buildPageVo(changeRecordPageInfo.getTotal(), pageSize, page);
        ChangeFlowListVO changeFlowListVO = new ChangeFlowListVO();
        changeFlowListVO.setPageVo(pageVO);
        changeFlowListVO.setChangeFlowList(list);
        return changeFlowListVO;
    }

    /**
     * 构建分页信息
     *
     * @param total
     * @param pageSize
     * @param page
     * @return
     */
    private PageVO buildPageVo(Long total, Integer pageSize, Integer page) {
        Integer totalCount = Math.toIntExact(total);
        int totalPage;
        int i = totalCount % pageSize;
        if (i != 0) {
            totalPage = totalCount / pageSize + 1;
        } else {
            totalPage = totalCount / pageSize;
        }
        return PageVO.builder().page(page).totalPage(totalPage).pageSize(pageSize).pageCount(pageSize)
                .totalCount(totalCount).build();
    }

    public UserBaseContainerDTO getOperator(InterfaceInputDTO interfaceInput) {
        log.info("[getOperator] interfaceInput:{}", JSON.toJSONString(interfaceInput));
        // 根据工单flowId获取审批人，创建工单时设置，唯一
        String flowId = interfaceInput.getPublicFieldDTO().getFlowMeta().getFlowId();
        String nodeId = interfaceInput.getPublicFieldDTO().getFlowMeta().getCurrNodeDataList().get(0).getNodeId();
        log.info("[getOperator] flowId:{}, nodeId:{}", flowId, nodeId);
        ChangeRecord changeRecord;
        changeRecord = changeFlowService.getByFlowId(Long.valueOf(flowId));
        log.info("[getOperator] first time get changeCommander:{}", changeRecord);
        // 创建工单后落库，此时审批人还未落库，工单平台无法查询到审批人，方法休眠500ms
        if (changeRecord == null) {
            try {
                Thread.sleep(500);
                changeRecord = changeFlowService.getByFlowId(Long.valueOf(flowId));
                log.info("[getOperator] second time get changeCommander:{}", changeRecord);
            } catch (Exception e) {
                log.info("[getOperator] flowId:{}, nodeId:{}, e={}", flowId, nodeId, e);
            }
        }
        String changeCommander = changeRecord.getChangeCommander();
        UserReachDTO userReachDTO = new UserReachDTO();
        userReachDTO.setUserName(changeCommander);
        userReachDTO.setUid(changeCommander);
        List<UserReachDTO> totalUserList = Collections.singletonList(userReachDTO);
        UserBaseContainerDTO userBaseContainer = new UserBaseContainerDTO();
        userBaseContainer.setUserList(totalUserList);
        return userBaseContainer;
    }

    public void export(ChangeFlowListQueryReq changeFlowListQueryReq, HttpServletResponse response) {
        List<ChangeRecord> changeRecords = changeRecordMapper.selectByCondition(changeFlowListQueryReq);
        if (CollectionUtils.isEmpty(changeRecords)) {
            throw ExceptionFactory.createBiz(ResponseCode.EMPTY, "无导出数据");
        }
        List<ChangeFlowExcelDTO> changeFlowExcelDTOList = changeRecords.stream().map(record -> {
            ChangeFlowExcelDTO changeFlowExcelDTO = new ChangeFlowExcelDTO();
            changeFlowExcelDTO.setId(record.getId());
            changeFlowExcelDTO.setChangeSubject(ChangeSubjectEnum.getChangeSubjectEnum(record.getChangeSubject()).getDesc());
            ChangeType parentChangeType = changeTypeService.getChangeTypeById(record.getParentChangeClassId());
            ChangeType sonChangeType = changeTypeService.getChangeTypeById(record.getSonChangeClassId());
            changeFlowExcelDTO.setChangeType(parentChangeType.getTypeName() + ">" + sonChangeType.getTypeName());
            changeFlowExcelDTO.setChangeDepartment(record.getChangeDepartment());
            changeFlowExcelDTO.setChangeContent(record.getChangeContent());
            changeFlowExcelDTO.setChangeCommander(record.getChangeCommander());
            String changeItemJsonStr = record.getChangeItem();
            if (StringUtils.isNotBlank(changeItemJsonStr)) {
                List<ItemVO> itemVOS = JSON.parseArray(changeItemJsonStr, ItemVO.class);
                changeFlowExcelDTO.setChangeItems(itemVOS.stream().map(item -> item.getItemId() + item.getItemName())
                        .collect(Collectors.joining(",")));
            }
            if (StringUtils.isNotBlank(record.getChangeSupplier())) {
                changeFlowExcelDTO.setSupplier(record.getChangeSupplier());
            }
            changeFlowExcelDTO.setChangeState(record.getState());
            // todo:变更发起人组织查询：姓名（组织架构三级部门）/供应商ID/system+发起时间
            changeFlowExcelDTO.setChangeCreator(record.getCreator());
            changeFlowExcelDTO.setExecDepartmentStrList(record.getParticipateChangeExecDepartment());
            changeFlowExcelDTO.setCreateTime(record.getCreateTime());
            return changeFlowExcelDTO;
        }).collect(Collectors.toList());
        Workbook workbook = ExcelExportUtil.exportExcel(new ExportParams(), ChangeFlowExcelDTO.class, changeFlowExcelDTOList);
        downLoadExcel("变更管理列表", response, workbook);
    }

    private void downLoadExcel(String fileName, HttpServletResponse response, Workbook workbook) {
        try {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Content-Disposition",
                    "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8") + ".xls");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            workbook.write(baos);
            response.setHeader("Content-Length", String.valueOf(baos.size()));
            OutputStream out = response.getOutputStream();
            out.write(baos.toByteArray());

        } catch (IOException ex) {
            throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST);
        }
    }

    public void deliver(@Valid ChangeFlowDeliverReq req) {
        log.info("[deliver] req:{}", JSON.toJSONString(req));
        Long flowId = req.getFlowId();
        // 查询工单有效性
        ChangeRecord changeRecord = getFlowInfo(flowId);
        log.info("[deliver] nodeId:{}", changeRecord.getFlowNode());
        // 检查工单节点
        List<String> nodeList = Arrays.asList(ChangeFlowEnum.CHANGE_FLOW_SUBMIT.getNodeId(),
            ChangeFlowEnum.CHANGE_FLOW_CONFIRM.getNodeId());
        this.checkNode(changeRecord.getFlowNode(), nodeList);
        String uid = RequestLocalBean.getUid();
        String changeCommander = changeRecord.getChangeCommander();
        if (!uid.equals(changeCommander)) {
            throw ExceptionFactory.createBiz(ResponseCode.NO_AUTH, ResponseCode.NO_AUTH.getMsg());
        }
        // 工单审核人转交
        String deliverUser = req.getDeliverUser();
        UserBaseDTO userBaseDTO = new UserBaseDTO();
        userBaseDTO.setUserName(deliverUser);
        userBaseDTO.setUid(deliverUser);
        String remark = req.getRemark();
        Map<String, Object> content = new HashMap<>(CommonConstants.INIT_HASH_MAP_SIZE);
        content.put("updateTime", System.currentTimeMillis());
        flowService.updateApprovers(ChangeFlowEnum.CHANGE_FLOW_EXE.getTopoId(), flowId.toString(),
                changeRecord.getFlowNode(), Collections.singletonList(userBaseDTO), uid,
                uid, remark, JSON.toJSONString(content));
        // 待办转交
        todoService.progressTodoTask(changeRecord, OperateTypeEnum.DELIVER.getType());
        // 更新工单负责人
        changeRecord.setChangeCommander(deliverUser);
        changeRecord.setRemark(remark);
        changeRecord.setUpdateTime(DateUtils.getCurrentTime());

        Map<String, Object> cancelMap = new HashMap<>();
        cancelMap.put("changeId", changeRecord.getId());
        cancelMap.put("changeSubject", changeRecord.getChangeSubject());
        cancelMap.put("changeContent", changeRecord.getChangeContent());
        // todo:负责人名称
        cancelMap.put("changeCommander", null);
        cancelMap.put("changeCommanderEmail", changeRecord.getChangeCommander());
        // todo:负责人名称
        cancelMap.put("restsChangeCommander", null);
        cancelMap.put("restsChangeCommanderEmail", changeRecord.getChangeCommander());
        String cancelSubjectParam = changeRecord.getId().toString();
        qcSendEmail(changeCommander, cancelSubjectParam, EmailTemplateEnum.YX_QC_CHANGE_SUBMIT_FORWARD, cancelMap);
        // 如果是供应商，再次发送供应商邮件
        if (changeRecord.getCreateSource().equals(CreateSourceEnum.TONG_ZHOU.getType())) {
            sendSupplierEmail.sendSupplierEmail(changeRecord.getChangeSupplier(), cancelSubjectParam,
                    EmailTemplateEnum.YX_QC_CHANGE_SUBMIT_FORWARD, cancelMap);
        }
        changeFlowService.updateRecord(changeRecord);
    }
}
