package com.netease.mail.yanxuan.change.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.netease.mail.yanxuan.change.biz.meta.exception.ExceptionFactory;
import com.netease.mail.yanxuan.change.biz.service.InteriorChangeConfigService;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeConfigService;
import com.netease.mail.yanxuan.change.common.bean.ResponseCode;
import com.netease.mail.yanxuan.change.common.enums.ChangeCommanderEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeSubjectEnum;
import com.netease.mail.yanxuan.change.dal.entity.ChangeConfig;
import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeCommanderPO;
import com.netease.mail.yanxuan.change.dal.meta.model.rpc.GoodsPurchaseRpc;
import com.netease.mail.yanxuan.change.dal.meta.model.rpc.GoodsResponseRpc;
import com.netease.mail.yanxuan.change.dal.meta.model.rpc.GoodsResponseSqeRpc;
import com.netease.mail.yanxuan.change.integration.flow.goods.ItemcenterApiRpcService;
import com.netease.mail.yanxuan.change.integration.flow.goods.PfuApiRpcService;
import com.netease.mail.yanxuan.change.integration.flow.goods.QcApiRpcService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierSendService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @author WangJiaXiang
 * @date 2022/11/18/018$
 */
@Service
public class InteriorChangeConfigServiceImpl implements InteriorChangeConfigService {

    private static Logger logger = LoggerFactory.getLogger(InteriorChangeConfigServiceImpl.class);

    @Autowired
    private ChangeConfigService changeConfigService;

    //查询商品的SQE
    @Autowired
    private QcApiRpcService qcApiRpcService;
    //查看执行人
    @Autowired
    private PfuApiRpcService pfuApiRpcService;
    //查看商品BU
    @Autowired
    private ItemcenterApiRpcService itemcenterApiRpcService;
    @Autowired
    private FlowRpcSupplierSendService supplierSendService;

    @Override
    public GoodsResponseRpc queryCommanderInfo(ChangeCommanderPO changeCommander) {
        //获取模板名称   通过一级变更类型 二级变更类型ID 定位模板
        ChangeConfig changeConfig = changeConfigService.queryChangeType(changeCommander.getParentChangeClassId(), changeCommander.getSonChangeClassId());
        if (changeConfig == null){
            return null;
        }
        //查询出当前模板配置中选择的 角色
        ChangeCommanderEnum changeCommanderEnum = ChangeCommanderEnum.getChangeCommanderEnum(changeConfig.getChangeCommanderType());
        //直接排除 选项为固定人 或者发起人
        if (changeCommanderEnum.getId() == 1 || changeCommanderEnum.getId() == 2){
            //固定人或者发起人  changeConfig.getChangeCommander();
            return null;
        }
        ChangeSubjectEnum changeSubjectEnum = ChangeSubjectEnum.getChangeSubjectEnum(changeConfig.getChangeSubject());
        if (changeSubjectEnum.getType() == 1){
            //商品变更
            return queryGoodsCommander(changeCommanderEnum,changeCommander.getGoodsInfos(),changeConfig.getChangeCommander());
        }else if (changeSubjectEnum.getType() == 2){
            //供应商  采购 计划 SQE
            return queryChangeSupplier(changeCommanderEnum,changeCommander.getChangeSupplierId(),changeConfig.getChangeCommander());
        }
        //其他变更 备注 其他变更之后固定人 和发起人在上面判断会被排除掉     changeConfig.getChangeCommander();
        return null;

    }

    /**
     * 商品的最终角色查询
     * @param commanderEnum   查询方向 枚举
     * @param goodsInfos  商品的列表
     * @param commander   商品的关联角色
     * @return
     */
    private GoodsResponseRpc queryGoodsCommander(ChangeCommanderEnum commanderEnum,List<Long> goodsInfos,String commander){
        if (commanderEnum.getId() != 3 || goodsInfos == null || goodsInfos.size() == 0 || commander == null){
            return null;
        }
        Map<String,GoodsResponseRpc> map = new HashMap<String,GoodsResponseRpc>();
        //记录最大出现次数
        int temp = 0;
        //记录最大值
        GoodsResponseRpc name = new GoodsResponseRpc();
        //记录出现的所有值
        List<GoodsResponseRpc> emails = new ArrayList<GoodsResponseRpc>();
        //遍历取出所有商品关联的人
        if (commander.equals("商品BU")) {
            String detail = itemcenterApiRpcService.getDetail(goodsInfos);
            logger.error("根据商品查看商品负责BU接口返回值\t"+detail);
            getGoodsNameEmail(emails,detail);
        } else if (commander.equals("采购")) {
            //采购返回值处理逻辑
            String detail = supplierSendService.queryGoodsPurchase(goodsInfos);
            logger.error("根据商品查看商品负责采购接口返回值\t"+detail);
            JSONObject jsonObject = JSONObject.parseObject(detail);
            List<GoodsPurchaseRpc> purchaseRpcs = JSONObject.parseArray(jsonObject.get("data").toString(), GoodsPurchaseRpc.class);
            for (GoodsPurchaseRpc purchaseRpc : purchaseRpcs){
                GoodsResponseRpc goodsRpc = new GoodsResponseRpc();
                goodsRpc.setEmail(purchaseRpc.getSupplierTraceBusiness());
                goodsRpc.setName(purchaseRpc.getSupplierName());
                emails.add(goodsRpc);
            }
        } else if (commander.equals("计划")) {
            String detail = pfuApiRpcService.getDetail(goodsInfos);
            logger.error("根据商品查看商品负责计划接口返回值\t"+detail);
            getGoodsNameEmail(emails,detail);
        } else if (commander.equals("SQE")) {
            for (Long goods:goodsInfos) {
                String detail = qcApiRpcService.getDetail(goods.intValue());
                logger.error("根据商品查看商品负责SQE接口返回值\t"+detail);
                JSONObject jsonObject = JSONObject.parseObject(detail);
                GoodsResponseSqeRpc data = jsonObject.getObject("data", GoodsResponseSqeRpc.class);
                if (data != null){
                    //需要验证返回值 是否正确
                    GoodsResponseRpc rpc = new GoodsResponseRpc();
                    rpc.setEmail(data.getUserName());
                    rpc.setName(data.getRealName());
                }
            }
        }
        //逻辑发生变更
        for (GoodsResponseRpc email : emails){
            if (!map.containsKey(email.getName())){
                email.setOccurrenceNumber(1);
            }else{
                GoodsResponseRpc goodsResponseRpc = map.get(email.getName());
                email.setOccurrenceNumber(goodsResponseRpc.getOccurrenceNumber()+1);
                if (temp < goodsResponseRpc.getOccurrenceNumber()){
                    temp = goodsResponseRpc.getOccurrenceNumber();
                    name = goodsResponseRpc;
                }
            }
            map.put(email.getName(),email);
        }
        if (name == null){
            Iterator<GoodsResponseRpc> iterator = map.values().iterator();
            name = iterator.next();
        }
        return name;
    }



    /**
     * 供应商角色最终查询
     * @param commanderEnum   查询方向 枚举
     * @param changeSupplierId 供应商信息
     * @param commander      供应商关联角色
     * @return
     */
    private GoodsResponseRpc queryChangeSupplier(ChangeCommanderEnum commanderEnum,String changeSupplierId,String commander){
        if (commanderEnum.getId() != 4 || changeSupplierId == null || commander == null){
            return null;
        }
        //changeSupplier 根据提供的信息去查询 最终返回
        if (commander.equals("采购")){

        }else if (commander.equals("计划")){

        }else if (commander.equals("SQE")){

        }
        return null;
    }


    /**
     * 重复代码复用方法
     * @param emails 储存邮箱队列
     * @param response  请求返结果
     */
    private void getGoodsNameEmail(List<GoodsResponseRpc> emails,String response){
        JSONObject jsonObject = JSONObject.parseObject(response);
        Map<String,JSONObject> rpcMap = JSONObject.parseObject(jsonObject.get("data").toString(), Map.class);
        if (rpcMap == null){
            throw ExceptionFactory.createBiz(ResponseCode.OPERATOR_NOT_EXIST);
        }
        for (String rpc : rpcMap.keySet()){
            GoodsResponseRpc goodsRpc = new GoodsResponseRpc();
            goodsRpc.setEmail(rpcMap.get(rpc).get("uid").toString());
            goodsRpc.setName(rpcMap.get(rpc).get("name").toString());
            emails.add(goodsRpc);
        }
    }


}
