package com.netease.mail.yanxuan.change.biz.service.impl.change;

import com.netease.mail.yanxuan.change.common.bean.ResponseCode;
import com.netease.mail.yanxuan.change.biz.meta.exception.ExceptionFactory;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeTypeService;
import com.netease.mail.yanxuan.change.dal.entity.ChangeType;
import com.netease.mail.yanxuan.change.dal.mapper.ChangeTypeMapper;
import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeTypePo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

import java.util.*;

/**
 * @author WangJiaXiang
 * @date 2022/11/11/011$
 */
@Service
public class ChangeTypeServiceImpl implements ChangeTypeService {

    @Autowired
    private ChangeTypeMapper mapper;

    @Override
    public List<ChangeType> queryChangeType(Long id,Long sonChangeClassId, Boolean deleteTab) {
        Integer delete = deleteTab?0:1;
        return mapper.queryTypes(id,sonChangeClassId,delete);
    }

    Logger logger = LoggerFactory.getLogger(ChangeTypeServiceImpl.class);

    @Override
    @Transactional
    public List<ChangeType> addChangeType(List<ChangeType> changeTypes) {
        if (changeTypes.size() != 2){
            throw ExceptionFactory.createBiz(ResponseCode.PARAMETER_LENGTH);
        }
        logger.info("查看一级二级入参数量"+changeTypes.size() + "值\n" +changeTypes);
        //验证字符串长度
        if (changeTypes.get(0).getTypeName().length() > 20 && changeTypes.get(1).getTypeName().length() > 20){
            throw ExceptionFactory.createBiz(ResponseCode.PARAMETER_LENGTH);
        }
        ChangeType changeType = queryRepetitionChangeType(changeTypes);
        if (changeType == null) {
            //初始化参数载入
            changeTypes.get(0).setCreateTime(System.currentTimeMillis());
            changeTypes.get(0).setUpdateTime(System.currentTimeMillis());
            changeTypes.get(0).setParentId(0L);
            mapper.insertSelective(changeTypes.get(0));
        }else{
            changeTypes.set(0,changeType);
            changeTypes.get(1).setParentId(changeType.getId());
        }
        //初始化参数载入
        changeTypes.get(1).setParentId(changeTypes.get(0).getId());
        changeTypes.get(1).setCreateTime(System.currentTimeMillis());
        changeTypes.get(1).setUpdateTime(System.currentTimeMillis());
        mapper.insertSelective(changeTypes.get(1));
        return changeTypes;
    }

    @Override
    public List<ChangeType> updateChangeType(List<ChangeType> changeTypes) {
        //根据传进来的一级ID 和二级ID 进行查询
        List<ChangeType> changeTypeList = mapper.queryTypes(changeTypes.get(0).getId(), changeTypes.get(1).getId(), 0);
        if (changeTypeList.get(0).getTypeName().equals(changeTypes.get(0).getTypeName())) {
            if (changeTypeList.get(1).getTypeName().equals(changeTypes.get(1).getTypeName())){
                //未改变情况直接返回
                return changeTypes;
            }else{
                //一级未改变  二级发生改变
                List<ChangeType> sonChanges = mapper.queryParent(changeTypes.get(0).getId());
                for (ChangeType sonChange : sonChanges){
                    if (sonChange.getTypeName().equals(changeTypes.get(1).getTypeName())){
                        deleteChangeType(changeTypes.get(1));
                        changeTypes.set(1,sonChange);
                        return changeTypes;
                    }
                }
                //发现没有直接新增并返回
                changeTypes.get(1).setId(null);
                changeTypes.get(1).setParentId(changeTypes.get(0).getId());
                changeTypes.get(1).setCreateTime(System.currentTimeMillis());
                changeTypes.get(1).setUpdateTime(System.currentTimeMillis());
                mapper.insertSelective(changeTypes.get(1));
                return changeTypes;
            }
        }else{
            //查询 所有一级ID 是否有重复的
            ChangeType changeParentType = mapper.queryTypeName(changeTypes.get(0).getTypeName());
            if (changeParentType == null){
                //ID置空
                changeTypes.get(0).setId(null);
                changeTypes.get(1).setId(null);
                //新增一级二级并返回
                return addChangeType(changeTypes);
            }
            //查询二级
            List<ChangeType> sonChanges = mapper.queryParent(changeParentType.getId());
            for (ChangeType sonChange : sonChanges){
                if (sonChange.getTypeName().equals(changeTypes.get(1).getTypeName())){
                    deleteChangeType(changeTypes.get(1));
                    changeTypes.set(1,sonChange);
                    return changeTypes;
                }
            }
            //发现没有直接新增并返回
            changeTypes.get(1).setId(null);
            changeTypes.get(1).setParentId(changeParentType.getId());
            changeTypes.get(1).setCreateTime(System.currentTimeMillis());
            changeTypes.get(1).setUpdateTime(System.currentTimeMillis());
            mapper.insertSelective(changeTypes.get(1));
            return changeTypes;
        }
    }

    @Override
    @Transactional
    public Boolean deleteChangeTypes(List<ChangeType> changeTypes) {
        if (changeTypes.get(0) == null || changeTypes.get(1) == null){
            throw ExceptionFactory.createParamFail();
        }
        //查询一级下班是否还存在其他二级  如果不存在就删除一级 如果存在一级就不做伪删
        List<ChangeType> changeTypeList = mapper.queryParent(changeTypes.get(0).getId());
        if (changeTypeList.size() == 2){
            changeTypes.remove(0);
        }
        for (ChangeType changeType : changeTypes){
            Example example = new Example(ChangeType.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.orEqualTo("id",changeType.getId());
            changeType.setDeleteType(1);
            changeType.setUpdateTime(System.currentTimeMillis());
            mapper.updateByExampleSelective(changeType,example);
        }
        return true;
    }

    public void deleteChangeType(ChangeType changeType) {
        if (changeType == null ){
            throw ExceptionFactory.createParamFail();
        }
        Example example = new Example(ChangeType.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.orEqualTo("id",changeType.getId());
        changeType.setDeleteType(1);
        changeType.setUpdateTime(System.currentTimeMillis());
        mapper.updateByExampleSelective(changeType,example);
    }


    @Override
    public List<ChangeTypePo> queryConfigType() {
        //获取数据,创建目录集合,遍历分组
        List<ChangeTypePo> changeTypes = mapper.queryArrayChangeTypes();
        List<ChangeTypePo> pos = new ArrayList<>();
        for (ChangeTypePo changeType : changeTypes) {
            if (changeType.getParentId() == 0){
                //如果是一级 插入MAP 并创建List列表
                changeType.setChangeTypes(new ArrayList<>());
                pos.add(changeType);
            }else{
               for (ChangeTypePo po : pos){
                   if (po.getId() == changeType.getParentId()){
                       po.getChangeTypes().add(changeType);
                   }
               }
            }
        }
        //去重如果父类下边包裹的List数量为0的时候就自动剔除
        pos.removeIf(changeTypePo -> changeTypePo.getChangeTypes().size() == 0);
        return pos;
    }

    @Override
    public ChangeType getChangeTypeById(Long id) {
        return mapper.selectByPrimaryKey(id);
    }

    /**
     * 判断变更类型是否重复(只判断未伪善出的)
     * @param changeTypes
     * @return
     */
    private ChangeType queryRepetitionChangeType(List<ChangeType> changeTypes) {
        if (changeTypes.get(0) == null || changeTypes.get(1) == null){
            throw ExceptionFactory.createParamFail();
        }
        //获取父类是否存在
        ChangeType changeParentType = mapper.queryTypeName(changeTypes.get(0).getTypeName());
        if (changeParentType == null){
           return null;
        }
        //如果存在查询父类下面所有子类 查询是否有重复的
        List<ChangeType> sonChangeTypes = mapper.queryParent(changeParentType.getId());
        for (ChangeType changeType : sonChangeTypes){
            if (changeType.getTypeName().equals(changeTypes.get(1).getTypeName())){
                throw ExceptionFactory.createBiz(ResponseCode.CHANGE_TYPE_NAME_TOW);
            }
        }
        return changeParentType;
    }



}
