/**
 * @(#)ChangeFlowExportCallback.java, 2022/12/8.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.callback;

import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.netease.mail.dp.des.process.api.entity.CallbackQueryReq;
import com.netease.mail.dp.des.process.api.entity.ExcelCell;
import com.netease.mail.dp.des.process.api.entity.ExcelTitle;
import com.netease.mail.dp.des.process.api.entity.PivotTable;
import com.netease.mail.dp.des.starter.callback.DesCallbackService;
import com.netease.mail.yanxuan.change.biz.service.ChangeFlowExportQuery;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeTypeService;
import com.netease.mail.yanxuan.change.common.enums.ChangeSubjectEnum;
import com.netease.mail.yanxuan.change.common.util.ExcelUtil;
import com.netease.mail.yanxuan.change.dal.entity.ChangeRecord;
import com.netease.mail.yanxuan.change.dal.entity.ChangeType;
import com.netease.mail.yanxuan.change.dal.mapper.ChangeRecordMapper;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowListQueryReq;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.ItemVO;
import com.netease.mail.yanxuan.change.integration.excel.ChangeFlowExcelDTO;
import com.netease.mail.yanxuan.change.integration.excel.ChangeFlowExcelVo;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author zcwang
 * @Date 2022/12/8
 */
@Slf4j
@Component
public class ChangeFlowExportCallback implements DesCallbackService {

    @Autowired
    private ChangeRecordMapper changeRecordMapper;
    
    @Autowired
    private ChangeTypeService changeTypeService;
    

    @Override
    public ExcelTitle queryExcelTitle(CallbackQueryReq req) {
        log.info("[op: change flow export callback queryExcelTitle] req={}", JSON.toJSONString(req));
        ChangeFlowExportQuery query = JSON.parseObject(req.getParamJson(), ChangeFlowExportQuery.class);
        ChangeFlowListQueryReq changeFlowListQueryReq = new ChangeFlowListQueryReq();
        BeanUtils.copyProperties(query, changeFlowListQueryReq);
        List<ChangeRecord> list = changeRecordMapper.selectByCondition(changeFlowListQueryReq);
        ExcelTitle excelTitle = ExcelUtil.fetchExceltile(ChangeFlowExcelVo.class);
        excelTitle.setTotal((long) list.size());
        log.info("[op: change flow export callback queryExcelTitle] result={}", JSON.toJSONString(excelTitle));
        return excelTitle;
    }

    @Override
    public List<List<ExcelCell>> queryExcelData(CallbackQueryReq req) {
        log.info("[op: address book export callback queryExcelData] req={}", JSON.toJSONString(req));
        ChangeFlowExportQuery query = JSON.parseObject(req.getParamJson(), ChangeFlowExportQuery.class);
        query.setOffset(req.getOffset());
        query.setLimit(req.getLimit());
        List<ChangeFlowExcelDTO> list = getExportList(query);
        return list.stream().map(ChangeFlowExcelVo::init).collect(Collectors.toList());
    }

    private List<ChangeFlowExcelDTO> getExportList(ChangeFlowExportQuery query) {
        ChangeFlowListQueryReq changeFlowListQueryReq = new ChangeFlowListQueryReq();
        BeanUtils.copyProperties(query, changeFlowListQueryReq);
        List<ChangeRecord> changeRecords = changeRecordMapper.selectByCondition(changeFlowListQueryReq);
        if (CollectionUtils.isEmpty(changeRecords)) {
            return Lists.newArrayList();
        }
        return changeRecords.stream().map(record -> {
            ChangeFlowExcelDTO changeFlowExcelDTO = new ChangeFlowExcelDTO();
            changeFlowExcelDTO.setId(record.getId());
            changeFlowExcelDTO
                .setChangeSubject(ChangeSubjectEnum.getChangeSubjectEnum(record.getChangeSubject()).getDesc());
            ChangeType parentChangeType = changeTypeService.getChangeTypeById(record.getParentChangeClassId());
            ChangeType sonChangeType = changeTypeService.getChangeTypeById(record.getSonChangeClassId());
            changeFlowExcelDTO.setChangeType(parentChangeType.getTypeName() + ">" + sonChangeType.getTypeName());
            changeFlowExcelDTO.setChangeDepartment(record.getChangeDepartment());
            changeFlowExcelDTO.setChangeContent(record.getChangeContent());
            changeFlowExcelDTO.setChangeCommander(record.getChangeCommander());
            String changeItemJsonStr = record.getChangeItem();
            if (StringUtils.isNotBlank(changeItemJsonStr)) {
                List<ItemVO> itemVOS = JSON.parseArray(changeItemJsonStr, ItemVO.class);
                changeFlowExcelDTO.setChangeItems(itemVOS.stream().map(item -> item.getItemId() + item.getItemName())
                    .collect(Collectors.joining(",")));
            }
            if (StringUtils.isNotBlank(record.getChangeSupplier())) {
                changeFlowExcelDTO.setSupplier(record.getChangeSupplier());
            }
            changeFlowExcelDTO.setChangeState(record.getState());
            // todo:变更发起人组织查询：姓名（组织架构三级部门）/供应商ID/system+发起时间
            changeFlowExcelDTO.setChangeCreator(record.getCreator());
            changeFlowExcelDTO.setExecDepartmentStrList(record.getParticipateChangeExecDepartment());
            changeFlowExcelDTO.setCreateTime(record.getCreateTime());
            return changeFlowExcelDTO;
        }).collect(Collectors.toList());

    }

    @Override
    public PivotTable queryPivotTable(CallbackQueryReq callbackQueryReq) {
        return null;
    }
}