/**
 * @(#)AutoSubmit.java, 2022/11/24.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.netease.mail.yanxuan.change.common.enums.*;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.biz.biz.ChangeFlowBiz;
import com.netease.mail.yanxuan.change.biz.service.ChangeFlowService;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeConfigService;
import com.netease.mail.yanxuan.change.biz.service.rpc.FlowService;
import com.netease.mail.yanxuan.change.biz.service.rpc.SupplierSendService;
import com.netease.mail.yanxuan.change.common.bean.CommonConstants;
import com.netease.mail.yanxuan.change.common.util.DateUtils;
import com.netease.mail.yanxuan.change.dal.entity.ChangeRecord;
import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeConfigPo;
import com.netease.mail.yanxuan.change.integration.email.enums.EmailTemplateEnum;
import com.netease.mail.yanxuan.dschedule.core.biz.model.ReturnT;
import com.netease.mail.yanxuan.dschedule.core.handler.IJobHandler;
import com.netease.mail.yanxuan.dschedule.core.handler.annotation.JobHandler;
import com.netease.yanxuan.flowx.sdk.meta.dto.base.FlowDataDTO;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author zcwang
 * @Date 2022/11/24
 */
@Component
@Slf4j
@JobHandler("AutoSubmit")
public class AutoSubmit extends IJobHandler {

    @Autowired
    private ChangeFlowService changeFlowService;

    @Autowired
    private FlowService flowService;

    @Autowired
    private ChangeFlowBiz changeFlowBiz;

    @Autowired
    private SupplierSendService sendSupplierEmail;

    @Autowired
    private ChangeConfigService changeConfigService;

    @Override
    public ReturnT<String> execute(String... strings) throws Exception {
        log.info("AutoSubmit start");
        long startTime = DateUtils.getCurrentTime();
        // 处理变更确认时间是今天24点之前的
        Long tomorrowSpecificTime = DateUtils.getTomorrowSpecificTime("00:00:00");
        List<Long> count = new ArrayList<>();
        Long entityId = 0L;
        // 查询今天时间之前的数据
        try {
            while (true) {
                List<ChangeRecord> records = changeFlowService.getByStatusAndTime(entityId, ChangeFlowEnum.CHANGE_FLOW_EXE.getNodeId(),
                        ChangeFlowEnum.CHANGE_FLOW_CONFIRM.getNodeId(), tomorrowSpecificTime);
                if (CollectionUtils.isEmpty(records)) {
                    break;
                }
                records.forEach(this::progressRecord);
                List<Long> idList = records.stream().map(ChangeRecord::getId).collect(Collectors.toList());
                entityId = idList.stream().max(Long::compare).get();
                count.addAll(idList);
            }
        } catch (Exception e) {
            log.error("error on AutoSubmit,e:{}", e);
        }
        log.info(
            "AutoSubmit end, count:{}, maxId:{}, usedTime:{}", count.size(), entityId, DateUtils.getCurrentTime() - startTime);
        return ReturnT.SUCCESS;
    }

    public void progressRecord(ChangeRecord changeRecord) {
        Long flowId = changeRecord.getFlowId();
        String flowNode = changeRecord.getFlowNode();
        String uid = changeRecord.getChangeCommander();
        // 执行变更节点，提交节点
        if (ChangeFlowEnum.CHANGE_FLOW_EXE.getNodeId().equals(flowNode)) {
            // 获取工单详情
            FlowDataDTO flowDataDTO = flowService.flowDetail(flowId.toString());
            if (flowDataDTO == null) {
                log.debug("[progressRecord] get flowDataDTO error, flowId{}", flowId);
            }
            // 工单流传
            Map<String, Object> content = new HashMap<>(CommonConstants.INIT_HASH_MAP_SIZE);
            content.put("updateTime", System.currentTimeMillis());
            content.put(CommonConstants.FLOW_OPERATION_KEY, FlowOperationTypeEnum.PASS.getValue());
            try {
                String execNode = flowService.submitFlow(flowId.toString(), flowDataDTO, uid,
                    ChangeFlowEnum.CHANGE_FLOW_EXE.getTopoId(), JSON.toJSONString(content), true,
                    FlowxOperationEnum.SUBMIT.getName(), "提交工单");
                // 更新工单数据
                changeRecord.setFlowNode(execNode);
                changeRecord.setUpdateTime(DateUtils.getCurrentTime());
                changeFlowService.updateRecord(changeRecord);
            } catch (Exception e) {
                log.debug("[progressRecord] submit error, flowId{}", flowId);
            }
        }
        // 发送邮件
        HashMap<String, Object> map = new HashMap<>();
        map.put("changeId", changeRecord.getFlowId());
        map.put("changeSubject", ChangeSubjectEnum.getChangeSubjectEnum(changeRecord.getChangeSubject()).getDesc());
        map.put("flowUrl", changeRecord.getFlowId());
        ChangeConfigPo changeConfigPo = changeConfigService.queryInfoPo(changeRecord.getParentChangeClassId(),
            changeRecord.getSonChangeClassId());
        StringBuilder changeType = new StringBuilder("");
        try {
            changeType.append(changeConfigPo.getChangeTypes().get(0).getTypeName());
        } catch (Exception e) {
            log.error("queryInfoPo error:{}", JSON.toJSONString(changeConfigPo));
        }
        try {
            changeType.append(changeConfigPo.getChangeTypes().get(1).getTypeName());
        } catch (Exception e) {
            log.error("queryInfoPo error:{}", JSON.toJSONString(changeConfigPo));
        }
        String subjectParam = ChangeSubjectEnum.getChangeSubjectEnum(changeRecord.getChangeSubject()).getDesc() + changeType
                + changeRecord.getFlowId().toString();
        changeFlowBiz.qcSendEmail(changeRecord.getChangeCommander(), subjectParam,
            EmailTemplateEnum.YX_QC_CHANGE_AFFIRM, map);
        // 如果是供应商，再次发送供应商邮件
        if (changeRecord.getCreateSource().equals(CreateSourceEnum.TONG_ZHOU.getType())) {
            sendSupplierEmail.sendSupplierEmail(changeRecord.getChangeSupplier(), subjectParam,
                EmailTemplateEnum.YX_QC_CHANGE_AFFIRM, map);
        }
    }
}