/**
 * @(#)ChangeFlowBiz.java, 2022/11/15.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.biz;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.biz.config.AppConfig;
import com.netease.mail.yanxuan.change.biz.meta.exception.ExceptionFactory;
import com.netease.mail.yanxuan.change.biz.service.ChangeFlowService;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeConfigService;
import com.netease.mail.yanxuan.change.common.bean.CommonConstants;
import com.netease.mail.yanxuan.change.common.bean.ResponseCode;
import com.netease.mail.yanxuan.change.common.bean.ResponseCodeEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeFlowEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeStatusEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeSubjectEnum;
import com.netease.mail.yanxuan.change.common.enums.FlowOperationTypeEnum;
import com.netease.mail.yanxuan.change.common.enums.FlowxOperationEnum;
import com.netease.mail.yanxuan.change.common.util.DateUtils;
import com.netease.mail.yanxuan.change.dal.entity.ChangeRecord;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeExecConfigReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowCreateReq;
import com.netease.mail.yanxuan.change.integration.flow.FlowRpcService;
import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;
import com.netease.yanxuan.flowx.sdk.meta.dto.base.FlowDataDTO;
import com.netease.yanxuan.flowx.sdk.meta.dto.flow.FlowCreateReqDTO;
import com.netease.yanxuan.flowx.sdk.meta.dto.flow.NodeSubmitReqDTO;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author zcwang
 * @Date 2022/11/15
 */
@Component
@Slf4j
public class ChangeFlowBiz {

    @Autowired
    private ChangeConfigService changeConfigService;

    @Autowired
    private ChangeFlowService changeFlowService;

    @Autowired
    private AppConfig appConfig;

    @Autowired
    private FlowRpcService flowRpcService;

    public Boolean createAndSubmit(ChangeFlowCreateReq changeFlowCreateReq) {
        // String uid = RequestLocalBean.getUid();
        String uid = "1";
        // String name = RequestLocalBean.getName();
        String name = "x@mesg.com";
        // 校验变更主体
        Boolean containsChangeSubject = ChangeSubjectEnum.getByType(changeFlowCreateReq.getChangeSubject());
        Assert.isTrue(containsChangeSubject, "变更主体不存在");
        // 检验是否需要资料
        // ChangeConfig changeConfig = changeConfigService.queryChangeConfig(changeFlowCreateReq.getSonChangeClassId());
        // Assert.notNull(changeConfig, "二级变更类型不存在");
        // Integer needFile = changeConfig.getNeedFile();
        // if (NeedFileEnum.NEED.getStatus().equals(needFile)) {
        //     Assert.notEmpty(changeFlowCreateReq.getFiles(), "必须上传资料");
        // }
        // 变更行动项不可为空，最多20项
        Assert.isTrue(changeFlowCreateReq.getChangeExecProject().size() <= appConfig.getChangeExecLimit(),
            "变更行动方案配置数超限");

        // 结束时间不可晚于第二天定时任务执行时间
        Long tomorrowSpecificTime = DateUtils.getTomorrowSpecificTime("09:00:00");
        Assert.isTrue(changeFlowCreateReq.getChangeConfirmResultTime() >= tomorrowSpecificTime, "时间不可晚于下次执行时间");
        Map<String, Object> content = new HashMap<>(10);
        content.put("createUserName", name);
        content.put("createUser", uid);
        content.put("createTime", System.currentTimeMillis());
        content.put("updateTime", System.currentTimeMillis());
        content.put(CommonConstants.FLOW_OPERATION_KEY, FlowOperationTypeEnum.PASS.getValue());
        // 组装工单创建数据
        FlowCreateReqDTO flowCreateReqDTO = buildFlowCreateReqDTO(ChangeFlowEnum.CHANGE_FLOW_CONFIRM.getTopoId(), uid, name, JSON.toJSONString(content),
                FlowxOperationEnum.CREATE.getName());
        // 创建工单
        String flowId = createFlow(flowCreateReqDTO);
        // 提交工单
        String nodeId = submitFlow(flowId, flowCreateReqDTO);
        // 保存工单数据
        ChangeRecord changeRecord = buildRecord(flowId, nodeId, changeFlowCreateReq);
        changeFlowService.saveRecord(changeRecord);
        return null;
    }

    private FlowCreateReqDTO buildFlowCreateReqDTO(String topoId, String uid, String userName, String content, String operateResult) {
        FlowCreateReqDTO flowCreateReqDTO = new FlowCreateReqDTO();
        flowCreateReqDTO.setTopoId(topoId);
        flowCreateReqDTO.setUid(uid);
        flowCreateReqDTO.setUserName(userName);
        flowCreateReqDTO.setOperateResult(operateResult);
        flowCreateReqDTO.setWorkOrderId(StringUtils.joinWith("-", topoId, UUID.randomUUID().toString()));
        return flowCreateReqDTO;
    }

    private String submitFlow(String flowId, FlowCreateReqDTO flowCreateReqDTO) {
        // 查询工单详情，根据详情提交
        FlowDataDTO flowDataDTO;
        AjaxResponse<FlowDataDTO> flowDetailResponse = flowRpcService.getDetail(CommonConstants.FLOWX_PRODUCT, flowId);
        if (ResponseCodeEnum.SUCCESS.getCode() == flowDetailResponse.getCode()) {
            flowDataDTO = flowDetailResponse.getData();
            log.info("[createAndSubmitFlow] flowDataDTO={}", JSON.toJSONString(flowDataDTO));
        } else {
            log.error("[createAndSubmitFlow] get flow detail failed, query={}, errMsg={}", JSON.toJSONString(flowId),
                    flowDetailResponse.getErrorMsg());
            throw ExceptionFactory.createBiz(ResponseCode.DETAIL_FLOW_ERROR, flowDetailResponse.getErrorMsg());
        }

        NodeSubmitReqDTO nodeSubmitReqDTO = new NodeSubmitReqDTO();
        nodeSubmitReqDTO.setFlowId(flowId);
        nodeSubmitReqDTO.setNodeId(flowDataDTO.getFlowMeta().getCurrNodeDataList().get(0).getNodeId());
        nodeSubmitReqDTO.setUid(flowCreateReqDTO.getUid());
        nodeSubmitReqDTO.setUserName(flowCreateReqDTO.getUserName());
        nodeSubmitReqDTO.setFlowId(flowId);
        nodeSubmitReqDTO.setTopoId(flowCreateReqDTO.getTopoId());
        nodeSubmitReqDTO.setContent(flowCreateReqDTO.getContent());
        nodeSubmitReqDTO.setOperateResult(FlowxOperationEnum.SUBMIT.getName());
        nodeSubmitReqDTO.setCreateTime(System.currentTimeMillis());
        List<String> nextNodeIdList;
        // 提交工单
        AjaxResponse<List<String>> submitResponse = flowRpcService.submit(CommonConstants.FLOWX_PRODUCT, nodeSubmitReqDTO);
        if (ResponseCodeEnum.SUCCESS.getCode() == flowDetailResponse.getCode()) {
            nextNodeIdList = submitResponse.getData();
            log.info("[createAndSubmitFlow] nextNodeIdList={}", JSON.toJSONString(nextNodeIdList));
        } else {
            log.error("[createAndSubmitFlow] submit flow failed, query={}, errMsg={}", JSON.toJSONString(flowId),
                    submitResponse.getErrorMsg());
            throw ExceptionFactory.createBiz(ResponseCode.SUBMIT_FLOW_ERROR, submitResponse.getErrorMsg());
        }
        return nextNodeIdList.get(0);
    }

    private String createFlow(FlowCreateReqDTO flowCreateReqDTO) {
        // 先创建工单，创建完成后直接提交
        log.info("[createAndSubmitFlow] flowCreateReqDTO={}", flowCreateReqDTO);
        AjaxResponse<String> flowCreateResponse = flowRpcService.create(CommonConstants.FLOWX_PRODUCT, flowCreateReqDTO);
        String flowId;
        if (ResponseCodeEnum.SUCCESS.getCode() == flowCreateResponse.getCode()) {
            flowId = flowCreateResponse.getData();
            log.info("[createAndSubmitFlow] flowId ={}", JSON.toJSONString(flowId));
        } else {
            log.error("[createAndSubmitFlow] create flow failed, query={}, errMsg={}", JSON.toJSONString(flowCreateReqDTO),
                    flowCreateResponse.getErrorMsg());
            throw ExceptionFactory.createBiz(ResponseCode.CREATE_FLOW_ERROR, flowCreateResponse.getErrorMsg());
        }
        return flowId;
    }

    private ChangeRecord buildRecord(String flowId, String nodeId, ChangeFlowCreateReq changeFlowCreateReq) {
        ChangeRecord changeRecord = new ChangeRecord();
        changeRecord.setFlowId(Long.parseLong(flowId));
        changeRecord.setFlowNode(nodeId);
        changeRecord.setChangeSubject(changeFlowCreateReq.getChangeSubject());
        changeRecord.setParentChangeClassId(changeFlowCreateReq.getParentChangeClassId());
        changeRecord.setSonChangeClassId(changeFlowCreateReq.getSonChangeClassId());
        changeRecord.setChangeLevel(changeFlowCreateReq.getChangeLevel());
        changeRecord.setChangeCommander(changeFlowCreateReq.getChangeCommander());
        changeRecord.setChangeDepartment(changeFlowCreateReq.getChangeDepartment());
        List<ChangeExecConfigReq> changeExecProject = changeFlowCreateReq.getChangeExecProject();
        List<String> execDepartmentList = changeExecProject.stream().map(ChangeExecConfigReq::getChangeExecDepartment)
            .collect(Collectors.toList());
        changeRecord.setParticipateChangeExecDepartment(JSON.toJSONString(execDepartmentList));
        changeRecord.setChangeItem(changeFlowCreateReq.getChangeItems());
        changeRecord.setChangeSupplier(changeFlowCreateReq.getChangeSupplier());
        changeRecord.setChangeReason(changeFlowCreateReq.getChangeReason());
        changeRecord.setChangeContent(changeFlowCreateReq.getChangeContent());
        changeRecord.setChangeRiskDesc(changeFlowCreateReq.getChangeRiskDesc());
        changeRecord.setChangeProfit(changeFlowCreateReq.getChangeProfit());
        changeRecord.setChangeProfitDesc(changeFlowCreateReq.getChangeProfitDesc());
        changeRecord.setChangeConfirmResultTime(changeFlowCreateReq.getChangeConfirmResultTime());
        changeRecord.setState(ChangeStatusEnum.IN.getStatus());
        changeRecord.setIsCancel(0);
        // 变更结论
        changeRecord.setChangeResult(1);
        changeRecord.setCreateSource(changeFlowCreateReq.getCreateSource());
        changeRecord.setCreateSupplier(changeFlowCreateReq.getChangeSupplier());
        changeRecord.setChangeResultDesc("");
        changeRecord.setRemark("");
        changeRecord.setCreator("");
        changeRecord.setCreateTime(DateUtils.getCurrentTime());
        changeRecord.setUpdateTime(DateUtils.getCurrentTime());
        return changeRecord;
    }
}
