/**
 * @(#)ChangeFlowBiz.java, 2022/11/15.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.biz;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import com.netease.mail.yanxuan.change.biz.config.AppConfig;
import com.netease.mail.yanxuan.change.biz.service.ChangeFlowService;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeConfigService;
import com.netease.mail.yanxuan.change.common.enums.ChangeStatusEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeSubjectEnum;
import com.netease.mail.yanxuan.change.common.enums.NeedFileEnum;
import com.netease.mail.yanxuan.change.common.util.DateUtils;
import com.netease.mail.yanxuan.change.dal.entity.ChangeConfig;
import com.netease.mail.yanxuan.change.dal.entity.ChangeRecord;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowCreateReq;

/**
 * @Author zcwang
 * @Date 2022/11/15
 */
@Component
public class ChangeFlowBiz {

    @Autowired
    private ChangeConfigService changeConfigService;

    @Autowired
    private ChangeFlowService changeFlowService;

    @Autowired
    private AppConfig appConfig;

    public Boolean createAndSubmit(ChangeFlowCreateReq changeFlowCreateReq) {
        // 校验变更主体
        Boolean containsChangeSubject = ChangeSubjectEnum.getByType(changeFlowCreateReq.getChangeSubject());
        Assert.isTrue(containsChangeSubject, "变更主体不存在");
        // 检验是否需要资料
        ChangeConfig changeConfig = changeConfigService.queryChangeConfig(changeFlowCreateReq.getSonChangeClassId());
        Assert.notNull(changeConfig, "二级变更类型不存在");
        Integer needFile = changeConfig.getNeedFile();
        if (NeedFileEnum.NEED.getStatus().equals(needFile)) {
            Assert.notEmpty(changeFlowCreateReq.getFiles(), "必须上传资料");
        }
        // 变更行动项不可为空，最多20项
        Assert.isTrue(changeFlowCreateReq.getChangeExecProject().size() <= appConfig.getChangeExecLimit(),
            "变更行动方案配置数超限");

        // 结束时间不可晚于第二天定时任务执行时间
        Long tomorrowSpecificTime = DateUtils.getTomorrowSpecificTime("09:00:00");
        Assert.isTrue(changeFlowCreateReq.getChangeConfirmResultTime() >= tomorrowSpecificTime, "时间不可晚于下次执行时间");
        // 创建并提交工作流

        // 保存工单数据
        ChangeRecord changeRecord = buildRecord(changeFlowCreateReq);
        changeFlowService.saveRecord(changeRecord);
        return null;
    }

    private ChangeRecord buildRecord(ChangeFlowCreateReq changeFlowCreateReq) {
        ChangeRecord changeRecord = new ChangeRecord();
        // todo
        changeRecord.setFlowId(1L);
        // todo
        changeRecord.setFlowNode("1");
        changeRecord.setChangeSubject(changeFlowCreateReq.getChangeSubject());
        changeRecord.setParentChangeClassId(changeFlowCreateReq.getParentChangeClassId());
        changeRecord.setSonChangeClassId(changeFlowCreateReq.getSonChangeClassId());
        changeRecord.setChangeLevel(changeFlowCreateReq.getChangeLevel());
        changeRecord.setChangeCommander(changeFlowCreateReq.getChangeCommander());
        changeRecord.setChangeItem(changeFlowCreateReq.getChangeItems());
        changeRecord.setChangeSupplier(changeFlowCreateReq.getChangeSupplier());
        changeRecord.setChangeReason(changeFlowCreateReq.getChangeReason());
        changeRecord.setChangeContent(changeFlowCreateReq.getChangeContent());
        changeRecord.setChangeRiskDesc(changeFlowCreateReq.getChangeRiskDesc());
        changeRecord.setChangeProfit(changeFlowCreateReq.getChangeProfit());
        changeRecord.setChangeProfitDesc(changeFlowCreateReq.getChangeProfitDesc());
        changeRecord.setChangeConfirmResultTime(changeFlowCreateReq.getChangeConfirmResultTime());
        changeRecord.setState(ChangeStatusEnum.IN.getStatus());
        changeRecord.setIsCancel(0);
        // 变更结论
        changeRecord.setChangeResult(1);
        changeRecord.setCreateSource(changeFlowCreateReq.getCreateSource());
        changeRecord.setCreateSupplier(changeFlowCreateReq.getChangeSupplier());
        changeRecord.setChangeResultDesc("");
        changeRecord.setRemark("");
        changeRecord.setCreator("");
        changeRecord.setCreateTime(DateUtils.getCurrentTime());
        changeRecord.setUpdateTime(DateUtils.getCurrentTime());
        return changeRecord;
    }
}
