/**
 * @(#)ChangeFlowController.java, 2022/11/14.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.web.controller;

import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.biz.biz.ChangeFlowBiz;
import com.netease.mail.yanxuan.change.biz.config.TitleConfig;
import com.netease.mail.yanxuan.change.biz.meta.AjaxResult;
import com.netease.mail.yanxuan.change.biz.service.ChangeFlowService;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowCreateReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowReq;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author zcwang
 * @Date 2022/11/14
 */
@Slf4j
@RestController
@RequestMapping("/change/flow")
public class ChangeFlowController {

    @Autowired
    private ChangeFlowService changeFlowService;

    @Autowired
    private ChangeFlowBiz changeFlowBiz;

    /**
     * 变更工单详情查询
     * @return
     */
    @GetMapping("/detail")
    public AjaxResult<Void> detail() {

        return AjaxResult.success();
    }

    /**
     * 变更工单列表查询
     * @return
     */
    @GetMapping("/query")
    public AjaxResult<Void> query() {
        return AjaxResult.success();
    }

    /**
     * 返回提示文案
     * @return
     */
    @GetMapping("/title")
    public AjaxResult<TitleConfig> title() {
        return AjaxResult.success(changeFlowService.getTitleConfig());
    }

    /**
     * 发起变更，自动跳转到第一个节点
     * @return
     */
    @PostMapping("/create")
    public AjaxResult<Boolean> createAndSubmit(@RequestBody @Valid ChangeFlowCreateReq changeFlowCreateReq) {
        log.info("[createAndSubmit] createAndSubmit req={}", JSON.toJSONString(changeFlowCreateReq));
        return AjaxResult.success(changeFlowBiz.createAndSubmit(changeFlowCreateReq));
    }

    /**
     * 变更工单提交
     * @return
     */
    @PostMapping("/submit")
    public AjaxResult<Boolean> submit(@RequestBody ChangeFlowReq changeFlowReq) {

        return AjaxResult.success();
    }

    /**
     * 工单转交
     * @return
     */
    @PostMapping("/deliver")
    public AjaxResult<Boolean> deliver() {
        return AjaxResult.success();
    }

    /**
     * 工单取消
     * @return
     */
    @GetMapping("/cancel")
    public AjaxResult<Void> cancel() {

        return AjaxResult.success();
    }

    /**
     * 引用变更工单
     * @return
     */
    @GetMapping("/quote")
    public AjaxResult<Void> quote() {

        return AjaxResult.success();
    }


    /**
     * 导出变更
     * @return
     */
    @PostMapping("/export")
    public AjaxResult<Void> export() {

        return AjaxResult.success();
    }
}