package com.netease.mail.yanxuan.change.integration.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.netease.mail.yanxuan.change.integration.rpc.RpcResultException;

import java.io.IOException;
import java.util.List;

public class RpcListResult<T> implements RpcTemplate.CallHandler<List<T>> {

    private final Class<T> tClass;

    public RpcListResult(Class<T> tClass) {
        this.tClass = tClass;
    }

    @Override
    public List<T> handle(String resp) throws IOException {
        JSONObject rpcResult = JSON.parseObject(resp);
        int code = rpcResult.getIntValue("code");
        if (code == 200) {
            return JSON.parseArray(rpcResult.getString("result"), tClass);
        }
        throw new RpcResultException("response error, code = " + code);
    }
}
