package com.netease.mail.yanxuan.change.integration.client;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.netease.mail.yanxuan.change.integration.rpc.RpcResultException;
import lombok.SneakyThrows;

import java.io.IOException;

public class RpcObjectDataMsg<T> implements RpcTemplate.CallHandler<T> {

    private Class<T> tClass;

    public RpcObjectDataMsg(Class<T> tClass) {
        this.tClass = tClass;
    }

    @SneakyThrows
    @Override
    public T handle(String resp) throws IOException {
        JSONObject rpcResult = JSON.parseObject(resp);
        int code = rpcResult.getIntValue("code");
        if (code == 200) {
            return JSON.parseObject(rpcResult.getString("data"), tClass);
        }
        throw new RpcResultException(rpcResult.getString("msg"));
    }
}
