package com.netease.mail.yanxuan.change.integration.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.netease.mail.yanxuan.change.integration.rpc.RpcResultException;

import java.io.IOException;

public class SinoInfoRpcObjectData<T> implements RpcTemplate.CallHandler<T> {

    private final Class<T> tClass;

    public SinoInfoRpcObjectData(Class<T> tClass) {
        this.tClass = tClass;
    }

    @Override
    public T handle(String resp) throws IOException {
        JSONObject rpcResult = JSON.parseObject(resp);
        int code = rpcResult.getIntValue("code");
        if (code == 200) {
            return JSON.parseObject(rpcResult.getString("shareInfo"), tClass);
        }
        throw new RpcResultException("response error, code = " + code);
    }
}
