package com.netease.mail.yanxuan.change.integration.email.enums;

import lombok.AllArgsConstructor;

@AllArgsConstructor
public enum StaffStatusEnum {

    /**
     * 正式
     */
    OFFICIAL(0, "正式"),
    /**
     * 试用
     */
    TRIAL(1, "试用"),

    /**
     * 外包
     */
    WB(2, "外包"),

    /**
     * 离职
     */
    DIMISSION(6, "离职"),
    ;

    public static StaffStatusEnum getByValue(Integer code) {
        for (StaffStatusEnum c: StaffStatusEnum.values()) {
            if (c.getType().equals(code)) {
                return c;
            }
        }
        return null;
    }

    private Integer type;

    private String name;

    public Integer getType() {
        return type;
    }

    public String getName() {
        return name;
    }

}
