package com.netease.mail.yanxuan.change.biz.service.impl.change;

import com.netease.mail.yanxuan.change.common.bean.ResponseCode;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.netease.mail.yanxuan.change.biz.meta.exception.ExceptionFactory;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeTypeService;
import com.netease.mail.yanxuan.change.dal.entity.ChangeType;
import com.netease.mail.yanxuan.change.dal.mapper.ChangeTypeMapper;
import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeTypePo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

import java.util.*;

/**
 * @author WangJiaXiang
 * @date 2022/11/11/011$
 */
@Service
public class ChangeTypeServiceImpl implements ChangeTypeService {

    @Autowired
    private ChangeTypeMapper mapper;

    @Override
    public List<ChangeType> queryChangeType(Long id,Long sonChangeClassId, Boolean deleteTab) {
        Integer delete = deleteTab?0:1;
        return mapper.queryTypes(id,sonChangeClassId,delete);
    }


    @Override
    @Transactional
    public List<ChangeType> addChangeType(List<ChangeType> changeTypes) {
        //验证字符串长度
        if (changeTypes.get(0).getTypeName().length() > 20 && changeTypes.get(0).getTypeName().length() > 20){
            throw ExceptionFactory.createBiz(ResponseCode.PARAMETER_LENGTH);
        }
        queryChangeType(changeTypes);
        int oneId = mapper.insertSelective(changeTypes.get(0));
        //id 载入
        changeTypes.get(0).setId((long) oneId);
        changeTypes.get(1).setParentId((long) oneId);
        int tow = mapper.insertSelective(changeTypes.get(1));
        changeTypes.get(1).setId((long) tow);
        return changeTypes;
    }

    @Override
    public List<ChangeType> updateChangeType(List<ChangeType> changeTypes) {
        deleteChangeType(changeTypes);
        return addChangeType(changeTypes);
    }

    @Override
    @Transactional
    public Boolean deleteChangeType(List<ChangeType> changeTypes) {
        if (changeTypes.get(0) == null || changeTypes.get(1) == null){
            throw ExceptionFactory.createParamFail();
        }
        for (ChangeType changeType : changeTypes){
            changeType.setDelete(1);
            mapper.updateByPrimaryKeySelective(changeType);
        }
        return true;
    }

    /**
     * 二级目录类型查询出所有一级二级
     *
     * @return
     */
//    @Override
//    public Map<ChangeType, List<ChangeType>> queryConfigType() {
//        //获取数据,创建目录集合,遍历分组
//        List<ChangeType> changeTypes = mapper.queryArrayChangeType();
//        Map<ChangeType,List<ChangeType>> typeMap = new HashMap<ChangeType,List<ChangeType>>();
//        for (ChangeType changeType : changeTypes) {
//            if (changeType.getParentId() == 0){
//                //如果是一级 插入MAP 并创建List列表
//                typeMap.put(changeType,new ArrayList<ChangeType>());
//            }else{
//                //二级 就找到父类的一级 并add进入一级的列表
//                for(ChangeType tpye : typeMap.keySet()){
//                    if (tpye.getId() == changeType.getParentId()){
//                        typeMap.get(tpye).add(changeType);
//                    }
//                }
//            }
//        }
//        //MAP 去重如果父类下边包裹的List数量为0的时候就自动剔除
//        typeMap.entrySet().removeIf(next -> next.getValue().size() == 0);
//        return typeMap;
//    }

    @Override
    public List<ChangeTypePo> queryConfigType() {
        //获取数据,创建目录集合,遍历分组
        List<ChangeTypePo> changeTypes = mapper.queryArrayChangeTypes();
        List<ChangeTypePo> pos = new ArrayList<>();
        for (ChangeTypePo changeType : changeTypes) {
            if (changeType.getParentId() == 0){
                //如果是一级 插入MAP 并创建List列表
                changeType.setChangeTypes(new ArrayList<>());
                pos.add(changeType);
            }else{
               for (ChangeTypePo po : pos){
                   if (po.getId() == changeType.getParentId()){
                       po.getChangeTypes().add(changeType);
                   }
               }
            }
        }
        //去重如果父类下边包裹的List数量为0的时候就自动剔除
        pos.removeIf(changeTypePo -> changeTypePo.getChangeTypes().size() == 0);
        return pos;
    }

    /**
     * 判断变更类型是否重复(只判断未伪善出的)
     * @param changeTypes
     * @return
     */
    private void queryChangeType(List<ChangeType> changeTypes) {
        if (changeTypes.get(0) == null || changeTypes.get(1) == null){
            throw ExceptionFactory.createParamFail();
        }
        int i = 0;
        for (ChangeType changeType : changeTypes){
            if (StringUtils.isEmpty(changeType.getTypeName())){
                throw ExceptionFactory.createBiz(ResponseCode.PARAM_MISS);
            }
            if (mapper.queryTypeName(changeType.getTypeName()) != null){
                throw ExceptionFactory.createBiz(i == 0?ResponseCode.CHANGE_TYPE_NAME_ONE:ResponseCode.CHANGE_TYPE_NAME_TOW);
            }
            i++;
        }
    }



}
