package com.netease.mail.yanxuan.change.web.controller;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.biz.config.AppConfig;
import com.netease.mail.yanxuan.change.biz.service.ISupplierItemService;
import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.common.bean.ResponseCodeEnum;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierSendService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierGoodsInfoReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierSearchRemoteReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.SupplierInfoRsp;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.SupplierSimpleRsp;
import com.netease.mail.yanxuan.change.integration.todo.SupplierItemPageVO;
import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collections;
import java.util.List;

/**
 * @author WangJiaXiang
 * @date 2022/12/7/007$
 */
@Slf4j
@RestController
@RequestMapping("/supplier")
public class SupplierController {

    @Autowired
    private FlowRpcSupplierService rpcSupplierService;

    @Autowired
    private ISupplierItemService supplierItemService;

    @Autowired
    private FlowRpcSupplierSendService supplierSendService;

    @Autowired
    private AppConfig appConfig;

    @GetMapping("/query/supplier/infos")
    public AjaxResult<List<SupplierSimpleRsp>> querySupplierInfos(
            @RequestParam(name = "name", required = false) String name,
            @RequestParam(name = "uid", required = false) String uid,
            @RequestParam(name = "fuzzySearchText") String fuzzySearchText) {
        if (name == null) {
            name = appConfig.getSearchName();
        }
        if (uid == null) {
            uid = appConfig.getSearchUid();
        }
        SupplierSearchRemoteReq req = new SupplierSearchRemoteReq();
        req.setSearchText(fuzzySearchText);
        AjaxResult<List<SupplierSimpleRsp>> supplierInfo = supplierSendService.queryByConditionForQc(req);
        if (ResponseCodeEnum.SUCCESS.getCode() == (supplierInfo.getCode())) {
            return supplierInfo;
        }
        log.error("[querySupplierInfos] querySupplierInfos failed, name={},uid={},fuzzySearchText={}, errMsg={}", name,
                uid, fuzzySearchText, JSON.toJSONString(supplierInfo));
        return null;
    }

    @GetMapping("/query/supplier/item")
    public AjaxResponse<SupplierItemPageVO> querySupplier(@RequestParam String supplier,
                                                          @RequestParam(required = false) String itemId,
                                                          @RequestParam(required = false) String itemName,
                                                          @RequestParam(defaultValue = "1") Integer page,
                                                          @RequestParam(defaultValue = "10") Integer pageSize) {
        SupplierGoodsInfoReq supplierGoodsInfoReq = new SupplierGoodsInfoReq();
        supplierGoodsInfoReq.setSupplierIds(supplier);
        return AjaxResponse.initSuccessResult(supplierItemService.supplierGoodsInfoBySupplier(supplierGoodsInfoReq, itemId, itemName, page, pageSize));
    }

}
