package com.netease.yanxuan.wx.store.sharer.integration.constant;

/**
 * @Description 短信常量类
 * @Author fanjiaxin
 * @Date 2025/3/11 11:59
 */
public class SmsConstant {

	/**
	 * 短信验证码缓存key，公共前缀
	 */
	public static final String SMS_VERIFY_CODE_COMMON_PREFIX = "act_mobile_verify_";

	/**
	 * 验证码发送标记缓存
	 * 验证码使用业务场景标识+手机号
	 */
	public static final String SMS_SEND_INTERVAL_KEY = SMS_VERIFY_CODE_COMMON_PREFIX + "send_interval_%s_%s";

	/**
	 * 用户当前验证码缓存
	 * 验证码使用业务场景标识+手机号
	 */
	public static final String SMS_CODE_KEY = SMS_VERIFY_CODE_COMMON_PREFIX + "code_%s_%s";

	/**
	 * 验证码每日发送次数上限缓存
	 * 验证码使用业务场景标识+手机号+今日0点时间戳毫秒
	 */
	public static final String SMS_SEND_COUNT_KEY = SMS_VERIFY_CODE_COMMON_PREFIX + "send_count_%s_%s_%s";

	/**
	 * 验证码每日校验次数上限缓存
	 * 验证码使用业务场景标识+手机号+今日0点时间戳毫秒
	 */
	public static final String SMS_VERIFY_COUNT_KEY = SMS_VERIFY_CODE_COMMON_PREFIX + "verify_count_%s_%s_%s";
}
