/**
 * @(#)FastJsonSerializer.java, 2020/12/11.
 * <p/>
 * Copyright 2020 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.yanxuan.wx.store.sharer.common.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;

/**
 * json序列化
 *
 * @author: 莫闲
 * @date: 2020-12-11 09:36
 **/
public class FastJsonSerializer {
    public FastJsonSerializer() {}

    public static String serialize(Object obj) {
        return JSON.toJSONString(obj,
            new SerializerFeature[] { SerializerFeature.WriteClassName });
    }

    public static Object deserialize(String content) {
        return JSON.parse(content);
    }

    static {
        ParserConfig.getGlobalInstance().addAccept("com.netease.");
    }
}
